/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.Fetch;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.Fetcher;
import org.apache.kafka.clients.consumer.internals.KafkaConsumerMetrics;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.OffsetFetcher;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TopicMetadataFetcher;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class KafkaConsumer<K, V>
implements Consumer<K, V> {
    private static final long NO_CURRENT_THREAD = -1L;
    static final long DEFAULT_CLOSE_TIMEOUT_MS = 30000L;
    static final String DEFAULT_REASON = "rebalance enforced by user";
    final Metrics metrics;
    final KafkaConsumerMetrics kafkaConsumerMetrics;
    private Logger log;
    private final String clientId;
    private final Optional<String> groupId;
    private final ConsumerCoordinator coordinator;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private final Fetcher<K, V> fetcher;
    private final OffsetFetcher offsetFetcher;
    private final TopicMetadataFetcher topicMetadataFetcher;
    private final ConsumerInterceptors<K, V> interceptors;
    private final IsolationLevel isolationLevel;
    private final Time time;
    private final ConsumerNetworkClient client;
    private final SubscriptionState subscriptions;
    private final ConsumerMetadata metadata;
    private final long retryBackoffMs;
    private final long requestTimeoutMs;
    private final int defaultApiTimeoutMs;
    private volatile boolean closed = false;
    private final List<ConsumerPartitionAssignor> assignors;
    private final AtomicLong currentThread = new AtomicLong(-1L);
    private final AtomicInteger refcount = new AtomicInteger(0);
    private boolean cachedSubscriptionHasAllFetchPositions;

    public KafkaConsumer(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public KafkaConsumer(Properties properties) {
        this(properties, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    public KafkaConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(Utils.propsToMap(properties), keyDeserializer, valueDeserializer);
    }

    public KafkaConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.appendDeserializerToConfig(configs, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    KafkaConsumer(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        try {
            GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig(config, GroupRebalanceConfig.ProtocolType.CONSUMER);
            this.groupId = Optional.ofNullable(groupRebalanceConfig.groupId);
            this.clientId = config.getString("client.id");
            LogContext logContext = ConsumerUtils.createLogContext(config, groupRebalanceConfig);
            this.log = logContext.logger(this.getClass());
            boolean enableAutoCommit = config.maybeOverrideEnableAutoCommit();
            this.groupId.ifPresent(groupIdStr -> {
                if (groupIdStr.isEmpty()) {
                    this.log.warn("Support for using the empty group id by consumers is deprecated and will be removed in the next major release.");
                }
            });
            this.log.debug("Initializing the Kafka consumer");
            this.requestTimeoutMs = config.getInt("request.timeout.ms").intValue();
            this.defaultApiTimeoutMs = config.getInt("default.api.timeout.ms");
            this.time = Time.SYSTEM;
            this.metrics = ConsumerUtils.createMetrics(config, this.time);
            this.retryBackoffMs = config.getLong("retry.backoff.ms");
            List interceptorList = ConsumerUtils.createConsumerInterceptors(config);
            this.interceptors = new ConsumerInterceptors(interceptorList);
            this.keyDeserializer = ConsumerUtils.createKeyDeserializer(config, keyDeserializer);
            this.valueDeserializer = ConsumerUtils.createValueDeserializer(config, valueDeserializer);
            this.subscriptions = ConsumerUtils.createSubscriptionState(config, logContext);
            ClusterResourceListeners clusterResourceListeners = this.configureClusterResourceListeners(this.keyDeserializer, this.valueDeserializer, this.metrics.reporters(), interceptorList);
            this.metadata = new ConsumerMetadata(config, this.subscriptions, logContext, clusterResourceListeners);
            List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config);
            this.metadata.bootstrap(addresses);
            FetchMetricsManager fetchMetricsManager = ConsumerUtils.createFetchMetricsManager(this.metrics);
            this.isolationLevel = ConsumerUtils.createIsolationLevel(config);
            ApiVersions apiVersions = new ApiVersions();
            this.client = ConsumerUtils.createConsumerNetworkClient(config, this.metrics, logContext, apiVersions, this.time, this.metadata, fetchMetricsManager.throttleTimeSensor(), this.retryBackoffMs);
            this.assignors = ConsumerPartitionAssignor.getAssignorInstances(config.getList("partition.assignment.strategy"), config.originals(Collections.singletonMap("client.id", this.clientId)));
            if (!this.groupId.isPresent()) {
                config.ignore("auto.commit.interval.ms");
                config.ignore("internal.throw.on.fetch.stable.offset.unsupported");
                this.coordinator = null;
            } else {
                this.coordinator = new ConsumerCoordinator(groupRebalanceConfig, logContext, this.client, this.assignors, this.metadata, this.subscriptions, this.metrics, "consumer", this.time, enableAutoCommit, config.getInt("auto.commit.interval.ms"), this.interceptors, config.getBoolean("internal.throw.on.fetch.stable.offset.unsupported"), config.getString("client.rack"));
            }
            FetchConfig<K, V> fetchConfig = ConsumerUtils.createFetchConfig(config, this.keyDeserializer, this.valueDeserializer);
            this.fetcher = new Fetcher<K, V>(logContext, this.client, this.metadata, this.subscriptions, fetchConfig, fetchMetricsManager, this.time);
            this.offsetFetcher = new OffsetFetcher(logContext, this.client, this.metadata, this.subscriptions, this.time, this.retryBackoffMs, this.requestTimeoutMs, this.isolationLevel, apiVersions);
            this.topicMetadataFetcher = new TopicMetadataFetcher(logContext, this.client, this.retryBackoffMs);
            this.kafkaConsumerMetrics = new KafkaConsumerMetrics(this.metrics, "consumer");
            config.logUnused();
            AppInfoParser.registerAppInfo("kafka.consumer", this.clientId, this.metrics, this.time.milliseconds());
            this.log.debug("Kafka consumer initialized");
        }
        catch (Throwable t) {
            if (this.log != null) {
                this.close(Duration.ZERO, true);
            }
            throw new KafkaException("Failed to construct kafka consumer", t);
        }
    }

    KafkaConsumer(LogContext logContext, String clientId, ConsumerCoordinator coordinator, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Fetcher<K, V> fetcher, OffsetFetcher offsetFetcher, TopicMetadataFetcher topicMetadataFetcher, ConsumerInterceptors<K, V> interceptors, Time time, ConsumerNetworkClient client, Metrics metrics, SubscriptionState subscriptions, ConsumerMetadata metadata, long retryBackoffMs, long requestTimeoutMs, int defaultApiTimeoutMs, List<ConsumerPartitionAssignor> assignors, String groupId) {
        this.log = logContext.logger(this.getClass());
        this.clientId = clientId;
        this.coordinator = coordinator;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.fetcher = fetcher;
        this.offsetFetcher = offsetFetcher;
        this.topicMetadataFetcher = topicMetadataFetcher;
        this.isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        this.interceptors = Objects.requireNonNull(interceptors);
        this.time = time;
        this.client = client;
        this.metrics = metrics;
        this.subscriptions = subscriptions;
        this.metadata = metadata;
        this.retryBackoffMs = retryBackoffMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.defaultApiTimeoutMs = defaultApiTimeoutMs;
        this.assignors = assignors;
        this.groupId = Optional.ofNullable(groupId);
        this.kafkaConsumerMetrics = new KafkaConsumerMetrics(metrics, "consumer");
    }

    @Override
    public Set<TopicPartition> assignment() {
        this.acquireAndEnsureOpen();
        try {
            Set<TopicPartition> set = Collections.unmodifiableSet(this.subscriptions.assignedPartitions());
            return set;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Set<String> subscription() {
        this.acquireAndEnsureOpen();
        try {
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(this.subscriptions.subscription()));
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            if (topics == null) {
                throw new IllegalArgumentException("Topic collection to subscribe to cannot be null");
            }
            if (topics.isEmpty()) {
                this.unsubscribe();
            } else {
                for (String topic : topics) {
                    if (!Utils.isBlank(topic)) continue;
                    throw new IllegalArgumentException("Topic collection to subscribe to cannot contain null or empty topic");
                }
                this.throwIfNoAssignorsConfigured();
                this.fetcher.clearBufferedDataForUnassignedTopics(topics);
                this.log.info("Subscribed to topic(s): {}", (Object)Utils.join(topics, ", "));
                if (this.subscriptions.subscribe(new HashSet<String>(topics), listener)) {
                    this.metadata.requestUpdateForNewTopics();
                }
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void subscribe(Collection<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.maybeThrowInvalidGroupIdException();
        if (pattern == null || pattern.toString().equals("")) {
            throw new IllegalArgumentException("Topic pattern to subscribe to cannot be " + (pattern == null ? "null" : "empty"));
        }
        this.acquireAndEnsureOpen();
        try {
            this.throwIfNoAssignorsConfigured();
            this.log.info("Subscribed to pattern: '{}'", (Object)pattern);
            this.subscriptions.subscribe(pattern, listener);
            this.coordinator.updatePatternSubscription(this.metadata.fetch());
            this.metadata.requestUpdateForNewTopics();
        }
        finally {
            this.release();
        }
    }

    @Override
    public void subscribe(Pattern pattern) {
        this.subscribe(pattern, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void unsubscribe() {
        this.acquireAndEnsureOpen();
        try {
            this.fetcher.clearBufferedDataForUnassignedPartitions(Collections.emptySet());
            if (this.coordinator != null) {
                this.coordinator.onLeavePrepare();
                this.coordinator.maybeLeaveGroup("the consumer unsubscribed from all topics");
            }
            this.subscriptions.unsubscribe();
            this.log.info("Unsubscribed all topics or patterns and assigned partitions");
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Collection<TopicPartition> partitions) {
        this.acquireAndEnsureOpen();
        try {
            if (partitions == null) {
                throw new IllegalArgumentException("Topic partition collection to assign to cannot be null");
            }
            if (partitions.isEmpty()) {
                this.unsubscribe();
            } else {
                for (TopicPartition tp : partitions) {
                    String topic = tp != null ? tp.topic() : null;
                    if (!Utils.isBlank(topic)) continue;
                    throw new IllegalArgumentException("Topic partitions to assign to cannot have null or empty topic");
                }
                this.fetcher.clearBufferedDataForUnassignedPartitions(partitions);
                if (this.coordinator != null) {
                    this.coordinator.maybeAutoCommitOffsetsAsync(this.time.milliseconds());
                }
                this.log.info("Assigned to partition(s): {}", (Object)Utils.join(partitions, ", "));
                if (this.subscriptions.assignFromUser(new HashSet<TopicPartition>(partitions))) {
                    this.metadata.requestUpdateForNewTopics();
                }
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    @Deprecated
    public ConsumerRecords<K, V> poll(long timeoutMs) {
        return this.poll(this.time.timer(timeoutMs), false);
    }

    @Override
    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.poll(this.time.timer(timeout), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerRecords<K, V> poll(Timer timer, boolean includeMetadataInTimeout) {
        this.acquireAndEnsureOpen();
        try {
            this.kafkaConsumerMetrics.recordPollStart(timer.currentTimeMs());
            if (this.subscriptions.hasNoSubscriptionOrUserAssignment()) {
                throw new IllegalStateException("Consumer is not subscribed to any topics or assigned any partitions");
            }
            do {
                this.client.maybeTriggerWakeup();
                if (includeMetadataInTimeout) {
                    this.updateAssignmentMetadataIfNeeded(timer, false);
                } else {
                    while (!this.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE), true)) {
                        this.log.warn("Still waiting for metadata");
                    }
                }
                Fetch<K, V> fetch = this.pollForFetches(timer);
                if (fetch.isEmpty()) continue;
                if (this.sendFetches() > 0 || this.client.hasPendingRequests()) {
                    this.client.transmitSends();
                }
                if (fetch.records().isEmpty()) {
                    this.log.trace("Returning empty records from `poll()` since the consumer's position has advanced for at least one topic partition");
                }
                ConsumerRecords<K, V> consumerRecords = this.interceptors.onConsume(new ConsumerRecords<K, V>(fetch.records()));
                return consumerRecords;
            } while (timer.notExpired());
            ConsumerRecords consumerRecords = ConsumerRecords.empty();
            return consumerRecords;
        }
        finally {
            this.release();
            this.kafkaConsumerMetrics.recordPollEnd(timer.currentTimeMs());
        }
    }

    private int sendFetches() {
        this.offsetFetcher.validatePositionsOnMetadataChange();
        return this.fetcher.sendFetches();
    }

    boolean updateAssignmentMetadataIfNeeded(Timer timer, boolean waitForJoinGroup) {
        if (this.coordinator != null && !this.coordinator.poll(timer, waitForJoinGroup)) {
            return false;
        }
        return this.updateFetchPositions(timer);
    }

    private Fetch<K, V> pollForFetches(Timer timer) {
        long pollTimeout = this.coordinator == null ? timer.remainingMs() : Math.min(this.coordinator.timeToNextPoll(timer.currentTimeMs()), timer.remainingMs());
        Fetch fetch = this.fetcher.collectFetch();
        if (!fetch.isEmpty()) {
            return fetch;
        }
        this.sendFetches();
        if (!this.cachedSubscriptionHasAllFetchPositions && pollTimeout > this.retryBackoffMs) {
            pollTimeout = this.retryBackoffMs;
        }
        this.log.trace("Polling for fetches with timeout {}", (Object)pollTimeout);
        Timer pollTimer = this.time.timer(pollTimeout);
        this.client.poll(pollTimer, () -> !this.fetcher.hasAvailableFetches());
        timer.update(pollTimer.currentTimeMs());
        return this.fetcher.collectFetch();
    }

    @Override
    public void commitSync() {
        this.commitSync(Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    public void commitSync(Duration timeout) {
        this.commitSync(this.subscriptions.allConsumed(), timeout);
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.commitSync(offsets, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.acquireAndEnsureOpen();
        long commitStart = this.time.nanoseconds();
        try {
            this.maybeThrowInvalidGroupIdException();
            offsets.forEach(this::updateLastSeenEpochIfNewer);
            if (!this.coordinator.commitOffsetsSync(new HashMap<TopicPartition, OffsetAndMetadata>(offsets), this.time.timer(timeout))) {
                throw new TimeoutException("Timeout of " + timeout.toMillis() + "ms expired before successfully committing offsets " + offsets);
            }
        }
        finally {
            this.kafkaConsumerMetrics.recordCommitSync(this.time.nanoseconds() - commitStart);
            this.release();
        }
    }

    @Override
    public void commitAsync() {
        this.commitAsync(null);
    }

    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        this.commitAsync(this.subscriptions.allConsumed(), callback);
    }

    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            this.log.debug("Committing offsets: {}", offsets);
            offsets.forEach(this::updateLastSeenEpochIfNewer);
            this.coordinator.commitOffsetsAsync(new HashMap<TopicPartition, OffsetAndMetadata>(offsets), callback);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(TopicPartition partition, long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("seek offset must not be a negative number");
        }
        this.acquireAndEnsureOpen();
        try {
            this.log.info("Seeking to offset {} for partition {}", (Object)offset, (Object)partition);
            SubscriptionState.FetchPosition newPosition = new SubscriptionState.FetchPosition(offset, Optional.empty(), this.metadata.currentLeader(partition));
            this.subscriptions.seekUnvalidated(partition, newPosition);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        long offset = offsetAndMetadata.offset();
        if (offset < 0L) {
            throw new IllegalArgumentException("seek offset must not be a negative number");
        }
        this.acquireAndEnsureOpen();
        try {
            if (offsetAndMetadata.leaderEpoch().isPresent()) {
                this.log.info("Seeking to offset {} for partition {} with epoch {}", new Object[]{offset, partition, offsetAndMetadata.leaderEpoch().get()});
            } else {
                this.log.info("Seeking to offset {} for partition {}", (Object)offset, (Object)partition);
            }
            Metadata.LeaderAndEpoch currentLeaderAndEpoch = this.metadata.currentLeader(partition);
            SubscriptionState.FetchPosition newPosition = new SubscriptionState.FetchPosition(offsetAndMetadata.offset(), offsetAndMetadata.leaderEpoch(), currentLeaderAndEpoch);
            this.updateLastSeenEpochIfNewer(partition, offsetAndMetadata);
            this.subscriptions.seekUnvalidated(partition, newPosition);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void seekToBeginning(Collection<TopicPartition> partitions) {
        if (partitions == null) {
            throw new IllegalArgumentException("Partitions collection cannot be null");
        }
        this.acquireAndEnsureOpen();
        try {
            Collection<TopicPartition> parts = partitions.size() == 0 ? this.subscriptions.assignedPartitions() : partitions;
            this.subscriptions.requestOffsetReset(parts, OffsetResetStrategy.EARLIEST);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void seekToEnd(Collection<TopicPartition> partitions) {
        if (partitions == null) {
            throw new IllegalArgumentException("Partitions collection cannot be null");
        }
        this.acquireAndEnsureOpen();
        try {
            Collection<TopicPartition> parts = partitions.size() == 0 ? this.subscriptions.assignedPartitions() : partitions;
            this.subscriptions.requestOffsetReset(parts, OffsetResetStrategy.LATEST);
        }
        finally {
            this.release();
        }
    }

    @Override
    public long position(TopicPartition partition) {
        return this.position(partition, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    public long position(TopicPartition partition, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            if (!this.subscriptions.isAssigned(partition)) {
                throw new IllegalStateException("You can only check the position for partitions assigned to this consumer.");
            }
            Timer timer = this.time.timer(timeout);
            do {
                SubscriptionState.FetchPosition position;
                if ((position = this.subscriptions.validPosition(partition)) != null) {
                    long l = position.offset;
                    return l;
                }
                this.updateFetchPositions(timer);
                this.client.poll(timer);
            } while (timer.notExpired());
            throw new TimeoutException("Timeout of " + timeout.toMillis() + "ms expired before the position for partition " + partition + " could be determined");
        }
        finally {
            this.release();
        }
    }

    @Override
    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.committed(partition, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return this.committed(Collections.singleton(partition), timeout).get(partition);
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.committed(partitions, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        this.acquireAndEnsureOpen();
        long start = this.time.nanoseconds();
        try {
            this.maybeThrowInvalidGroupIdException();
            Map<TopicPartition, OffsetAndMetadata> offsets = this.coordinator.fetchCommittedOffsets(partitions, this.time.timer(timeout));
            if (offsets == null) {
                throw new TimeoutException("Timeout of " + timeout.toMillis() + "ms expired before the last committed offset for partitions " + partitions + " could be determined. Try tuning default.api.timeout.ms larger to relax the threshold.");
            }
            offsets.forEach(this::updateLastSeenEpochIfNewer);
            Map<TopicPartition, OffsetAndMetadata> map = offsets;
            return map;
        }
        finally {
            this.kafkaConsumerMetrics.recordCommitted(this.time.nanoseconds() - start);
            this.release();
        }
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.partitionsFor(topic, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Cluster cluster = this.metadata.fetch();
            List<PartitionInfo> parts = cluster.partitionsForTopic(topic);
            if (!parts.isEmpty()) {
                List<PartitionInfo> list = parts;
                return list;
            }
            Timer timer = this.time.timer(timeout);
            List<PartitionInfo> topicMetadata = this.topicMetadataFetcher.getTopicMetadata(topic, this.metadata.allowAutoTopicCreation(), timer);
            List<PartitionInfo> list = topicMetadata != null ? topicMetadata : Collections.emptyList();
            return list;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        return this.listTopics(Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Map<String, List<PartitionInfo>> map = this.topicMetadataFetcher.getAllTopicMetadata(this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(Collection<TopicPartition> partitions) {
        this.acquireAndEnsureOpen();
        try {
            this.log.debug("Pausing partitions {}", partitions);
            for (TopicPartition partition : partitions) {
                this.subscriptions.pause(partition);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Collection<TopicPartition> partitions) {
        this.acquireAndEnsureOpen();
        try {
            this.log.debug("Resuming partitions {}", partitions);
            for (TopicPartition partition : partitions) {
                this.subscriptions.resume(partition);
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public Set<TopicPartition> paused() {
        this.acquireAndEnsureOpen();
        try {
            Set<TopicPartition> set = Collections.unmodifiableSet(this.subscriptions.pausedPartitions());
            return set;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.offsetsForTimes(timestampsToSearch, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            for (Map.Entry<TopicPartition, Long> entry : timestampsToSearch.entrySet()) {
                if (entry.getValue() >= 0L) continue;
                throw new IllegalArgumentException("The target time for partition " + entry.getKey() + " is " + entry.getValue() + ". The target time cannot be negative.");
            }
            Map<TopicPartition, OffsetAndTimestamp> map = this.offsetFetcher.offsetsForTimes(timestampsToSearch, this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.beginningOffsets(partitions, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Map<TopicPartition, Long> map = this.offsetFetcher.beginningOffsets(partitions, this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.endOffsets(partitions, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Map<TopicPartition, Long> map = this.offsetFetcher.endOffsets(partitions, this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionalLong currentLag(TopicPartition topicPartition) {
        this.acquireAndEnsureOpen();
        try {
            Long lag = this.subscriptions.partitionLag(topicPartition, this.isolationLevel);
            if (lag == null) {
                if (this.subscriptions.partitionEndOffset(topicPartition, this.isolationLevel) == null && !this.subscriptions.partitionEndOffsetRequested(topicPartition)) {
                    this.log.info("Requesting the log end offset for {} in order to compute lag", (Object)topicPartition);
                    this.subscriptions.requestPartitionEndOffset(topicPartition);
                    this.offsetFetcher.endOffsets(Collections.singleton(topicPartition), this.time.timer(0L));
                }
                OptionalLong optionalLong = OptionalLong.empty();
                return optionalLong;
            }
            OptionalLong optionalLong = OptionalLong.of(lag);
            return optionalLong;
        }
        finally {
            this.release();
        }
    }

    @Override
    public ConsumerGroupMetadata groupMetadata() {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            ConsumerGroupMetadata consumerGroupMetadata = this.coordinator.groupMetadata();
            return consumerGroupMetadata;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void enforceRebalance(String reason) {
        this.acquireAndEnsureOpen();
        try {
            if (this.coordinator == null) {
                throw new IllegalStateException("Tried to force a rebalance but consumer does not have a group.");
            }
            this.coordinator.requestRejoin(reason == null || reason.isEmpty() ? DEFAULT_REASON : reason);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void enforceRebalance() {
        this.enforceRebalance(null);
    }

    @Override
    public void close() {
        this.close(Duration.ofMillis(30000L));
    }

    @Override
    public void close(Duration timeout) {
        if (timeout.toMillis() < 0L) {
            throw new IllegalArgumentException("The timeout cannot be negative.");
        }
        this.acquire();
        try {
            if (!this.closed) {
                this.close(timeout, false);
            }
        }
        finally {
            this.closed = true;
            this.release();
        }
    }

    @Override
    public void wakeup() {
        this.client.wakeup();
    }

    private ClusterResourceListeners configureClusterResourceListeners(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, List<?> ... candidateLists) {
        ClusterResourceListeners clusterResourceListeners = new ClusterResourceListeners();
        for (List<?> candidateList : candidateLists) {
            clusterResourceListeners.maybeAddAll(candidateList);
        }
        clusterResourceListeners.maybeAdd(keyDeserializer);
        clusterResourceListeners.maybeAdd(valueDeserializer);
        return clusterResourceListeners;
    }

    private Timer createTimerForRequest(Duration timeout) {
        Time localTime = this.time == null ? Time.SYSTEM : this.time;
        return localTime.timer(Math.min(timeout.toMillis(), this.requestTimeoutMs));
    }

    private void close(Duration timeout, boolean swallowException) {
        this.log.trace("Closing the Kafka consumer");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        Timer closeTimer = this.createTimerForRequest(timeout);
        if (this.coordinator != null) {
            Utils.swallow(this.log, Level.ERROR, "Failed to close coordinator with a timeout(ms)=" + closeTimer.timeoutMs(), () -> this.coordinator.close(closeTimer), firstException);
        }
        if (this.fetcher != null) {
            long remainingDurationInTimeout = Math.max(0L, timeout.toMillis() - closeTimer.elapsedMs());
            if (remainingDurationInTimeout > 0L) {
                remainingDurationInTimeout = Math.min(this.requestTimeoutMs, remainingDurationInTimeout);
            }
            closeTimer.reset(remainingDurationInTimeout);
            Utils.swallow(this.log, Level.ERROR, "Failed to close fetcher with a timeout(ms)=" + closeTimer.timeoutMs(), () -> this.fetcher.close(closeTimer), firstException);
        }
        Utils.closeQuietly(this.interceptors, "consumer interceptors", firstException);
        Utils.closeQuietly(this.kafkaConsumerMetrics, "kafka consumer metrics", firstException);
        Utils.closeQuietly(this.metrics, "consumer metrics", firstException);
        Utils.closeQuietly(this.client, "consumer network client", firstException);
        Utils.closeQuietly(this.keyDeserializer, "consumer key deserializer", firstException);
        Utils.closeQuietly(this.valueDeserializer, "consumer value deserializer", firstException);
        AppInfoParser.unregisterAppInfo("kafka.consumer", this.clientId, this.metrics);
        this.log.debug("Kafka consumer has been closed");
        Throwable exception = firstException.get();
        if (exception != null && !swallowException) {
            if (exception instanceof InterruptException) {
                throw (InterruptException)exception;
            }
            throw new KafkaException("Failed to close kafka consumer", exception);
        }
    }

    private boolean updateFetchPositions(Timer timer) {
        this.offsetFetcher.validatePositionsIfNeeded();
        this.cachedSubscriptionHasAllFetchPositions = this.subscriptions.hasAllFetchPositions();
        if (this.cachedSubscriptionHasAllFetchPositions) {
            return true;
        }
        if (this.coordinator != null && !this.coordinator.refreshCommittedOffsetsIfNeeded(timer)) {
            return false;
        }
        this.subscriptions.resetInitializingPositions();
        this.offsetFetcher.resetPositionsIfNeeded();
        return true;
    }

    private void acquireAndEnsureOpen() {
        this.acquire();
        if (this.closed) {
            this.release();
            throw new IllegalStateException("This consumer has already been closed.");
        }
    }

    private void acquire() {
        Thread thread = Thread.currentThread();
        long threadId = thread.getId();
        if (threadId != this.currentThread.get() && !this.currentThread.compareAndSet(-1L, threadId)) {
            throw new ConcurrentModificationException("KafkaConsumer is not safe for multi-threaded access. currentThread(name: " + thread.getName() + ", id: " + threadId + ") otherThread(id: " + this.currentThread.get() + ")");
        }
        this.refcount.incrementAndGet();
    }

    private void release() {
        if (this.refcount.decrementAndGet() == 0) {
            this.currentThread.set(-1L);
        }
    }

    private void throwIfNoAssignorsConfigured() {
        if (this.assignors.isEmpty()) {
            throw new IllegalStateException("Must configure at least one partition assigner class name to partition.assignment.strategy configuration property");
        }
    }

    private void maybeThrowInvalidGroupIdException() {
        if (!this.groupId.isPresent()) {
            throw new InvalidGroupIdException("To use the group management or offset commit APIs, you must provide a valid group.id in the consumer configuration.");
        }
    }

    private void updateLastSeenEpochIfNewer(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        if (offsetAndMetadata != null) {
            offsetAndMetadata.leaderEpoch().ifPresent(epoch -> this.metadata.updateLastSeenEpochIfNewer(topicPartition, (int)epoch));
        }
    }

    String getClientId() {
        return this.clientId;
    }

    boolean updateAssignmentMetadataIfNeeded(Timer timer) {
        return this.updateAssignmentMetadataIfNeeded(timer, true);
    }
}

