/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.Arrays;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.LineAppender;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.Type;

public abstract class PropertyFormat
extends LineAppender
implements Localized {
    protected transient Format columnFormat;

    protected PropertyFormat(Appendable appendable) {
        super(appendable);
    }

    public final void appendValue(Object object) throws IOException {
        this.appendValue(object, false);
    }

    private void appendValue(Object object, boolean bl) throws IOException {
        CharSequence charSequence;
        if (object == null) {
            charSequence = " ";
        } else if (this.columnFormat != null) {
            if (this.columnFormat instanceof CompoundFormat) {
                this.appendCompound((CompoundFormat)this.columnFormat, object);
                return;
            }
            charSequence = this.columnFormat.format(object);
        } else if (object instanceof InternationalString) {
            charSequence = ((InternationalString)object).toString(this.getLocale());
        } else if (object instanceof CharSequence) {
            charSequence = object.toString();
        } else if (object instanceof CodeList) {
            charSequence = MetadataServices.getInstance().getCodeTitle((CodeList)object, this.getLocale());
        } else if (object instanceof Enum) {
            charSequence = CharSequences.upperCaseToSentence(((Enum)object).name());
        } else {
            if (object instanceof Type) {
                this.appendName(((Type)object).getTypeName());
                return;
            }
            if (object instanceof Locale) {
                Locale locale = this.getLocale();
                charSequence = locale != Locale.ROOT ? ((Locale)object).getDisplayName(locale) : object.toString();
            } else if (object instanceof TimeZone) {
                Locale locale = this.getLocale();
                charSequence = locale != Locale.ROOT ? ((TimeZone)object).getDisplayName(locale) : ((TimeZone)object).getID();
            } else if (object instanceof Charset) {
                Locale locale = this.getLocale();
                charSequence = locale != Locale.ROOT ? ((Charset)object).displayName(locale) : ((Charset)object).name();
            } else if (object instanceof Currency) {
                Locale locale = this.getLocale();
                charSequence = locale != Locale.ROOT ? ((Currency)object).getDisplayName(locale) : object.toString();
            } else {
                if (object instanceof Record) {
                    this.appendCollection(((Record)object).getAttributes().values(), bl);
                    return;
                }
                if (object instanceof Iterable) {
                    this.appendCollection((Iterable)object, bl);
                    return;
                }
                if (object instanceof Object[]) {
                    this.appendCollection(Arrays.asList((Object[])object), bl);
                    return;
                }
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (k == null) {
                        this.append(null);
                    } else {
                        this.appendValue(k, bl);
                    }
                    if (v != null) {
                        this.append(" \u2192 ");
                        this.appendValue(v, bl);
                    }
                    return;
                }
                charSequence = this.toString(object);
            }
        }
        this.append(charSequence);
    }

    protected String toString(Object object) {
        return object.toString();
    }

    private void appendCollection(Iterable<?> iterable, boolean bl) throws IOException {
        if (iterable != null) {
            if (bl) {
                this.append('\u2026');
            } else {
                int n = 0;
                for (Object obj : iterable) {
                    if (obj == null) continue;
                    if (n != 0) {
                        this.append(", ");
                    }
                    this.appendValue(obj, true);
                    if (++n != 10) continue;
                    this.append(", \u2026");
                    break;
                }
            }
        }
    }

    private <V> void appendCompound(CompoundFormat<V> compoundFormat, Object object) throws IOException {
        compoundFormat.format(compoundFormat.getValueType().cast(object), this);
    }

    private void appendName(GenericName genericName) throws IOException {
        Locale locale = this.getLocale();
        if (genericName != null) {
            String string;
            InternationalString internationalString = genericName.toInternationalString();
            if (internationalString != null && (string = internationalString.toString(locale)) != null) {
                this.append(string);
                return;
            }
            string = genericName.toString();
            if (string != null) {
                this.append(string);
                return;
            }
        }
        this.append('(').append(Vocabulary.getResources(locale).getString((short)208)).append(')');
    }
}

