/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.IOException;
import java.io.InputStream;

public class StructuredFieldReader {
    private InputStream inputStream = null;

    public StructuredFieldReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public byte[] getNext(byte[] identifier) throws IOException {
        int c;
        int bufferPointer = 0;
        byte[] bufferData = new byte[identifier.length + 2];
        for (int x = 0; x < identifier.length; ++x) {
            bufferData[x] = 0;
        }
        while ((c = this.inputStream.read()) > -1) {
            bufferData[bufferPointer] = (byte)c;
            int index = 0;
            boolean found = true;
            for (int i = identifier.length - 1; i > -1; --i) {
                int p = bufferPointer - index;
                if (p < 0) {
                    p = bufferData.length + p;
                }
                ++index;
                if (identifier[i] == bufferData[p]) continue;
                found = false;
                break;
            }
            if (found) {
                int b;
                byte[] length = new byte[2];
                int a = bufferPointer - identifier.length;
                if (a < 0) {
                    a = bufferData.length + a;
                }
                if ((b = bufferPointer - identifier.length - 1) < 0) {
                    b = bufferData.length + b;
                }
                length[0] = bufferData[b];
                length[1] = bufferData[a];
                int reclength = ((length[0] & 0xFF) << 8) + (length[1] & 0xFF) - identifier.length - 2;
                byte[] retval = new byte[reclength];
                this.inputStream.read(retval, 0, reclength);
                return retval;
            }
            if (++bufferPointer < bufferData.length) continue;
            bufferPointer = 0;
        }
        return null;
    }
}

