/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnsh;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jline.console.CommandRegistry;

public class ShellCommandRegistryHolder
implements AutoCloseable {
    private final List<CommandRegistry> commandRegistries = new ArrayList<CommandRegistry>();

    public void addCommandRegistry(CommandRegistry commandRegistry) {
        Objects.requireNonNull(commandRegistry, "commandRegistry");
        this.commandRegistries.add(commandRegistry);
    }

    public CommandRegistry[] getCommandRegistries() {
        return this.commandRegistries.toArray(new CommandRegistry[0]);
    }

    @Override
    public void close() throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (CommandRegistry commandRegistry : this.commandRegistries) {
            if (!(commandRegistry instanceof AutoCloseable)) continue;
            AutoCloseable closeable = (AutoCloseable)commandRegistry;
            try {
                closeable.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            IllegalStateException ex = new IllegalStateException("Could not close commandRegistries");
            exceptions.forEach(ex::addSuppressed);
            throw ex;
        }
    }
}

