/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.logging;

import org.apache.maven.logging.BuildEventListener;
import org.apache.maven.slf4j.MavenSimpleLogger;
import org.slf4j.MDC;

public class ProjectBuildLogAppender
implements AutoCloseable {
    private static final String KEY_PROJECT_ID = "maven.project.id";
    private static final ThreadLocal<String> PROJECT_ID = new InheritableThreadLocal<String>();
    private static final ThreadLocal<String> FORKING_PROJECT_ID = new InheritableThreadLocal<String>();
    private final BuildEventListener buildEventListener;

    public static String getProjectId() {
        return PROJECT_ID.get();
    }

    public static void setProjectId(String projectId) {
        String forkingProjectId = FORKING_PROJECT_ID.get();
        if (forkingProjectId != null) {
            projectId = projectId != null ? forkingProjectId + "/" + (String)projectId : forkingProjectId;
        }
        if (projectId != null) {
            PROJECT_ID.set((String)projectId);
            MDC.put((String)KEY_PROJECT_ID, (String)projectId);
        } else {
            PROJECT_ID.remove();
            MDC.remove((String)KEY_PROJECT_ID);
        }
    }

    public static void setForkingProjectId(String forkingProjectId) {
        if (forkingProjectId != null) {
            FORKING_PROJECT_ID.set(forkingProjectId);
        } else {
            FORKING_PROJECT_ID.remove();
        }
    }

    public static void updateMdc() {
        String id = ProjectBuildLogAppender.getProjectId();
        if (id != null) {
            MDC.put((String)KEY_PROJECT_ID, (String)id);
        } else {
            MDC.remove((String)KEY_PROJECT_ID);
        }
    }

    public ProjectBuildLogAppender(BuildEventListener buildEventListener) {
        this.buildEventListener = buildEventListener;
        MavenSimpleLogger.setLogSink(this::accept);
    }

    protected void accept(String message) {
        String projectId = MDC.get((String)KEY_PROJECT_ID);
        this.buildEventListener.projectLogMessage(projectId, message);
    }

    @Override
    public void close() throws Exception {
        MavenSimpleLogger.setLogSink(null);
    }
}

