/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.util;

public class PasswordUtil {
    public static boolean secureCompare(String input, String password, int loops) {
        if (loops < password.length()) {
            throw new IllegalArgumentException("loops must be equal or greater than the password length");
        }
        int result = input.length() ^ password.length();
        for (int i = 0; i < loops; ++i) {
            result |= input.charAt(i % input.length()) ^ password.charAt(i % password.length());
        }
        return result == 0;
    }

    public static boolean secureCompareFast(String input, String password) {
        int loops = password.length();
        int result = input.length() ^ password.length();
        for (int i = 0; i < loops; ++i) {
            result |= input.charAt(i % input.length()) ^ password.charAt(i % password.length());
        }
        return result == 0;
    }
}

