/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.Comparator;
import org.assertj.core.util.NullSafeComparator;

public class NaturalOrderComparator<T extends Comparable<? super T>>
extends NullSafeComparator<T> {
    private String description;

    public NaturalOrderComparator(Class<T> clazz) {
        this.description = String.format("%s natural order", clazz.getSimpleName());
    }

    public NaturalOrderComparator(String description) {
        this.description = description;
    }

    @Override
    protected int compareNonNull(T o1, T o2) {
        return Comparator.naturalOrder().compare(o1, o2);
    }

    public String toString() {
        return this.description;
    }
}

