/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDDeviceGray;

public class PDColorSpaceInstance {
    private PDColorSpace colorSpace = new PDDeviceGray();
    private COSArray colorSpaceValue = new COSArray();

    public PDColorSpaceInstance() {
        this.colorSpaceValue.add(new COSFloat(0.0f));
    }

    public Color createColor() throws IOException {
        Color retval = null;
        float[] components = this.colorSpaceValue.toFloatArray();
        if (components.length == 3) {
            retval = new Color(components[0], components[1], components[2]);
        } else {
            ColorSpace cs = this.colorSpace.createColorSpace();
            retval = new Color(cs, components, 1.0f);
        }
        return retval;
    }

    public PDColorSpaceInstance(COSArray csValues) {
        this.colorSpaceValue = csValues;
    }

    public PDColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(PDColorSpace value) {
        this.colorSpace = value;
    }

    public float[] getColorSpaceValue() {
        return this.colorSpaceValue.toFloatArray();
    }

    public COSArray getCOSColorSpaceValue() {
        return this.colorSpaceValue;
    }

    public void setColorSpaceValue(float[] value) {
        this.colorSpaceValue.setFloatArray(value);
    }
}

