/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;

public class StatementTablePermission
extends StatementPermission {
    UUID tableUUID;
    int privType;

    public StatementTablePermission(UUID uUID, int n) {
        this.tableUUID = uUID;
        this.privType = n;
    }

    public int getPrivType() {
        return this.privType;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            StatementTablePermission statementTablePermission = (StatementTablePermission)object;
            return this.privType == statementTablePermission.privType && this.tableUUID.equals(statementTablePermission.tableUUID);
        }
        return false;
    }

    public int hashCode() {
        return this.privType + this.tableUUID.hashCode();
    }

    public void check(LanguageConnectionContext languageConnectionContext, String string, boolean bl) throws StandardException {
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        if (!this.hasPermissionOnTable(dataDictionary, string, bl)) {
            TableDescriptor tableDescriptor = this.getTableDescriptor(dataDictionary);
            throw StandardException.newException(bl ? "28507" : "28506", string, (Object)this.getPrivName(), (Object)tableDescriptor.getSchemaName(), (Object)tableDescriptor.getName());
        }
    }

    protected TableDescriptor getTableDescriptor(DataDictionary dataDictionary) throws StandardException {
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableUUID);
        if (tableDescriptor == null) {
            throw StandardException.newException("28505", "table");
        }
        return tableDescriptor;
    }

    protected boolean hasPermissionOnTable(DataDictionary dataDictionary, String string, boolean bl) throws StandardException {
        return this.oneAuthHasPermissionOnTable(dataDictionary, "PUBLIC", bl) || this.oneAuthHasPermissionOnTable(dataDictionary, string, bl);
    }

    protected boolean oneAuthHasPermissionOnTable(DataDictionary dataDictionary, String string, boolean bl) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = dataDictionary.getTablePermissions(this.tableUUID, string);
        if (tablePermsDescriptor == null) {
            return false;
        }
        String string2 = null;
        switch (this.privType) {
            case 0: {
                string2 = tablePermsDescriptor.getSelectPriv();
                break;
            }
            case 1: {
                string2 = tablePermsDescriptor.getUpdatePriv();
                break;
            }
            case 2: {
                string2 = tablePermsDescriptor.getReferencesPriv();
                break;
            }
            case 3: {
                string2 = tablePermsDescriptor.getInsertPriv();
                break;
            }
            case 4: {
                string2 = tablePermsDescriptor.getDeletePriv();
                break;
            }
            case 5: {
                string2 = tablePermsDescriptor.getTriggerPriv();
            }
        }
        return "Y".equals(string2) || !bl && "y".equals(string2);
    }

    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dataDictionary, string, false)) {
            return dataDictionary.getTablePermissions(this.tableUUID, string);
        }
        return null;
    }

    public String getPrivName() {
        switch (this.privType) {
            case 0: {
                return "select";
            }
            case 1: {
                return "update";
            }
            case 2: {
                return "references";
            }
            case 3: {
                return "insert";
            }
            case 4: {
                return "delete";
            }
            case 5: {
                return "trigger";
            }
        }
        return "?";
    }
}

