/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandlerDelegate;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.view.facelets.tag.jsf.core.AjaxHandler;

public class BehaviorTagHandlerDelegate
extends TagHandlerDelegate
implements BehaviorHolderAttachedObjectHandler {
    private BehaviorHandler _delegate;

    public BehaviorTagHandlerDelegate(BehaviorHandler delegate) {
        this._delegate = delegate;
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew(parent)) {
            return;
        }
        if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent(parent)) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, this._delegate);
        } else {
            throw new TagException(this._delegate.getTag(), "Parent not composite component or an instance of ClientBehaviorHolder: " + parent);
        }
    }

    protected Behavior createBehavior(FaceletContext ctx) {
        if (this._delegate.getBehaviorId() == null) {
            throw new TagException(this._delegate.getTag(), "No behavior id defined");
        }
        return ctx.getFacesContext().getApplication().createBehavior(this._delegate.getBehaviorId());
    }

    @Override
    public MetaRuleset createMetaRuleset(Class type) {
        MetaRulesetImpl ruleset = new MetaRulesetImpl(this._delegate.getTag(), type);
        ((MetaRuleset)ruleset).ignore("binding");
        ((MetaRuleset)ruleset).ignore("event");
        return ruleset;
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)((Object)context.getAttributes().get("javax.faces.FACELET_CONTEXT"));
        ValueExpression ve = null;
        Behavior behavior = null;
        if (this._delegate.getBinding() != null) {
            ve = this._delegate.getBinding().getValueExpression(faceletContext, Behavior.class);
            behavior = (Behavior)ve.getValue((ELContext)faceletContext);
        }
        if (behavior == null) {
            behavior = this.createBehavior(faceletContext);
            if (ve != null) {
                ve.setValue((ELContext)faceletContext, (Object)behavior);
            }
        }
        if (behavior == null) {
            throw new TagException(this._delegate.getTag(), "No Validator was created");
        }
        this._delegate.setAttributes(faceletContext, behavior);
        if (behavior instanceof ClientBehavior) {
            ClientBehaviorHolder cvh = (ClientBehaviorHolder)((Object)parent);
            String eventName = this.getEventName();
            if (eventName == null) {
                eventName = cvh.getDefaultEventName();
            }
            if (eventName == null) {
                throw new TagAttributeException(this._delegate.getEvent(), "eventName could not be defined for client behavior " + behavior.toString());
            }
            if (!cvh.getEventNames().contains(eventName)) {
                throw new TagAttributeException(this._delegate.getEvent(), "eventName " + eventName + " not found on component instance");
            }
            cvh.addClientBehavior(eventName, (ClientBehavior)behavior);
            AjaxHandler.registerJsfAjaxDefaultResource(faceletContext, parent);
        }
    }

    @Override
    public String getFor() {
        TagAttribute forAttribute = this._delegate.getTagAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    @Override
    public String getEventName() {
        return this._delegate.getEventName();
    }
}

