/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.component.visit.MyFacesVisitHints;

public class RestoreViewSupport {
    private static final Logger log = Logger.getLogger(RestoreViewSupport.class.getName());
    private RenderKitFactory renderKitFactory = null;
    private VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory("javax.faces.component.visit.VisitContextFactory");

    public RestoreViewSupport(FacesContext facesContext) {
        this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processComponentBinding(FacesContext facesContext, UIComponent component) {
        try {
            facesContext.getAttributes().put("javax.faces.visit.SKIP_ITERATION", Boolean.TRUE);
            VisitContext visitContext = this.visitContextFactory.getVisitContext(facesContext, null, MyFacesVisitHints.SET_SKIP_ITERATION);
            component.visitTree(visitContext, new RestoreStateCallback());
        }
        finally {
            facesContext.getAttributes().remove("javax.faces.visit.SKIP_ITERATION");
        }
    }

    public boolean isPostback(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String renderkitId = viewHandler.calculateRenderKitId(facesContext);
        ResponseStateManager rsm = this.renderKitFactory.getRenderKit(facesContext, renderkitId).getResponseStateManager();
        return rsm.isPostback(facesContext);
    }

    private static class RestoreStateCallback
    implements VisitCallback {
        private PostRestoreStateEvent event;

        private RestoreStateCallback() {
        }

        @Override
        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this.event == null) {
                this.event = new PostRestoreStateEvent(target);
            } else {
                this.event.setComponent(target);
            }
            target.processEvent(this.event);
            return VisitResult.ACCEPT;
        }
    }
}

