/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.resolver;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.component.UIImportConstants;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;

public final class ImportConstantsELResolver
extends ELResolver {
    private static final String ERROR_MISSING_CLASS = "Cannot find type '%s' in classpath.";
    private static final String ERROR_FIELD_ACCESS = "Cannot access constant field '%s' of type '%s'.";
    private static final String IMPORT_CONSTANTS = "oam.importConstants";
    private Map<String, Map<String, Object>> constantsTypeMap = new ConcurrentHashMap<String, Map<String, Object>>();

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        Map constantsMap;
        String type;
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        FacesContext facesContext = ImportConstantsELResolver.facesContext(context);
        if (facesContext == null) {
            return null;
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            return null;
        }
        Map<String, String> importConstantsMap = (Map<String, String>)viewRoot.getTransientStateHelper().getTransient((Object)IMPORT_CONSTANTS);
        if (importConstantsMap == null) {
            Collection constants = ViewMetadata.getImportConstants((UIViewRoot)viewRoot);
            if (constants != null && !constants.isEmpty()) {
                importConstantsMap = new HashMap();
                for (UIImportConstants c : constants) {
                    String var = c.getVar();
                    String type2 = c.getType();
                    if (var == null) {
                        int innerClass = type2.lastIndexOf(36);
                        int outerClass = type2.lastIndexOf(46);
                        var = type2.substring(Math.max(innerClass, outerClass) + 1);
                    }
                    importConstantsMap.put(var, type2);
                }
            } else {
                importConstantsMap = Collections.emptyMap();
            }
            if (!FaceletViewDeclarationLanguage.isBuildingViewMetadata(facesContext)) {
                viewRoot.getTransientStateHelper().putTransient((Object)IMPORT_CONSTANTS, importConstantsMap);
            }
        }
        if (importConstantsMap != null && !importConstantsMap.isEmpty() && (type = (String)importConstantsMap.get((String)property)) != null && !(constantsMap = this.constantsTypeMap.computeIfAbsent(type, k -> ImportConstantsELResolver.collectConstants(type))).isEmpty()) {
            context.setPropertyResolved(true);
            return constantsMap;
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return null;
    }

    public void setValue(ELContext elc, Object o, Object o1, Object o2) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return base == null ? Object.class : null;
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    private static Map<String, Object> collectConstants(String type) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        for (Field field : ImportConstantsELResolver.toClass(type).getFields()) {
            if (!ImportConstantsELResolver.isPublicStaticFinal(field)) continue;
            try {
                constants.put(field.getName(), field.get(null));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(ERROR_FIELD_ACCESS, type, field.getName()), e);
            }
        }
        return constants;
    }

    static Class<?> toClass(String type) {
        try {
            return ClassUtils.classForName(type);
        }
        catch (ClassNotFoundException e) {
            int i = type.lastIndexOf(46);
            if (i > 0) {
                try {
                    return ImportConstantsELResolver.toClass(new StringBuilder(type).replace(i, i + 1, "$").toString());
                }
                catch (Exception ignore) {
                    Logger.getLogger(ImportConstantsELResolver.class.getName()).log(Level.FINE, "Ignoring thrown exception; previous exception will be rethrown instead.", ignore);
                }
            }
            throw new IllegalArgumentException(String.format(ERROR_MISSING_CLASS, type), e);
        }
    }

    private static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }
}

