/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.faces.FacesException;
import jakarta.servlet.ServletContext;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.webapp.FaceletsInitilializer;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.Jsp20FacesInitializer;
import org.apache.myfaces.webapp.Jsp21FacesInitializer;

public class FacesInitializerFactory {
    private static final String FACES_INITIALIZER_PARAM = "org.apache.myfaces.FACES_INITIALIZER";

    public static FacesInitializer getFacesInitializer(ServletContext context) {
        FacesInitializer initializer = FacesInitializerFactory._getFacesInitializerFromInitParam(context);
        if (initializer == null) {
            initializer = FacesInitializerFactory._getDefaultFacesInitializer(context);
        }
        return initializer;
    }

    private static FacesInitializer _getFacesInitializerFromInitParam(ServletContext context) {
        String initializerClassName = context.getInitParameter(FACES_INITIALIZER_PARAM);
        if (initializerClassName != null) {
            try {
                Class clazz = ClassUtils.classForName(initializerClassName);
                if (!FacesInitializer.class.isAssignableFrom(clazz)) {
                    throw new FacesException("Class " + clazz + " does not implement FacesInitializer");
                }
                return (FacesInitializer)ClassUtils.newInstance(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException("Could not find class of specified FacesInitializer", (Throwable)cnfe);
            }
        }
        return null;
    }

    private static FacesInitializer _getDefaultFacesInitializer(ServletContext context) {
        String initParameter = context.getInitParameter("org.apache.myfaces.SUPPORT_JSP_AND_FACES_EL");
        if (Boolean.FALSE.toString().equals(initParameter)) {
            return new FaceletsInitilializer();
        }
        if (ContainerUtils.isJsp21(context)) {
            return new Jsp21FacesInitializer();
        }
        return new Jsp20FacesInitializer();
    }
}

