/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.render;

import jakarta.faces.application.StateManager;
import jakarta.faces.context.FacesContext;
import java.io.IOException;

public abstract class ResponseStateManager {
    public static final String RENDER_KIT_ID_PARAM = "jakarta.faces.RenderKitId";
    public static final String VIEW_STATE_PARAM = "jakarta.faces.ViewState";
    public static final String CLIENT_WINDOW_PARAM = "jakarta.faces.ClientWindow";
    public static final String CLIENT_WINDOW_URL_PARAM = "jfwid";
    public static final String NON_POSTBACK_VIEW_TOKEN_PARAM = "jakarta.faces.Token";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeState(FacesContext context, Object state) throws IOException {
        StateManager.SerializedView view;
        if (state instanceof StateManager.SerializedView) {
            view = (StateManager.SerializedView)state;
        } else {
            StateManager stateManager;
            if (!(state instanceof Object[])) throw new IOException("The state should be an array of Object[] of lenght 2, or a SerializedView instance");
            Object[] structureAndState = (Object[])state;
            if (structureAndState.length != 2) throw new IOException("The state should be an array of Object[] of lenght 2");
            Object structureObj = structureAndState[0];
            Object stateObj = structureAndState[1];
            StateManager stateManager2 = stateManager = context.getApplication().getStateManager();
            stateManager2.getClass();
            view = stateManager2.new StateManager.SerializedView(structureObj, stateObj);
        }
        this.writeState(context, view);
    }

    @Deprecated
    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
    }

    public String getViewState(FacesContext context, Object state) {
        return null;
    }

    public Object getState(FacesContext context, String viewId) {
        Object[] structureAndState = new Object[]{this.getTreeStructureToRestore(context, viewId), this.getComponentStateToRestore(context)};
        return structureAndState;
    }

    @Deprecated
    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        return null;
    }

    @Deprecated
    public Object getComponentStateToRestore(FacesContext context) {
        return null;
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(VIEW_STATE_PARAM);
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        return null;
    }

    public boolean isStateless(FacesContext context, String viewId) {
        return false;
    }
}

