/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.myfaces.extensions.cdi.message.api.Localizable;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageInterpolator;
import org.apache.myfaces.extensions.cdi.message.api.NamedArgument;

public class NamedArgumentMessageInterpolator
implements MessageInterpolator {
    private static final long serialVersionUID = -8511553781756269753L;

    public String interpolate(MessageContext messageContext, String messageText, Serializable ... arguments) {
        NamedArgument[] namedArguments;
        for (NamedArgument namedArgument : namedArguments = this.extractNamedArguments(arguments)) {
            String name = "{" + namedArgument.getName() + "}";
            if (!messageText.contains(name)) continue;
            Object value = namedArgument.getValue();
            if (value instanceof Localizable) {
                value = ((Localizable)value).toString(messageContext);
            } else if (value == null) {
                value = "null";
            }
            messageText = messageText.replace(name, value.toString());
        }
        return messageText;
    }

    private NamedArgument[] extractNamedArguments(Serializable[] arguments) {
        ArrayList<NamedArgument> result = new ArrayList<NamedArgument>();
        for (Serializable argument : arguments) {
            if (!(argument instanceof NamedArgument)) continue;
            result.add((NamedArgument)argument);
        }
        return result.toArray(new NamedArgument[result.size()]);
    }
}

