/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneChoice;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectOneRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneChoiceRenderer<T extends AbstractUISelectOneChoice>
extends SelectOneRendererBase<T> {
    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_SELECT_ONE_CHOICE;
    }

    @Override
    protected CssItem[] getComponentCss(FacesContext facesContext, T command) {
        CssItem[] cssItemArray;
        if (this.isInside(facesContext, HtmlElements.TOBAGO_IN)) {
            CssItem[] cssItemArray2 = new CssItem[1];
            cssItemArray = cssItemArray2;
            cssItemArray2[0] = BootstrapClass.FORM_SELECT;
        } else {
            cssItemArray = null;
        }
        return cssItemArray;
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        super.encodeBeginInternal(facesContext, component);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        super.encodeEndInternal(facesContext, component);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String fieldId = this.getFieldId(facesContext, component);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, component);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        boolean disabled = !items.iterator().hasNext() || ((AbstractUISelectOneBase)component).isDisabled() || ((AbstractUISelectOneBase)component).isReadonly();
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        writer.startElement(HtmlElements.SELECT);
        writer.writeIdAttribute(fieldId);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectOneBase)component).getTabIndex());
        writer.writeClassAttribute(BootstrapClass.FORM_SELECT, markup.contains(Markup.LARGE) ? BootstrapClass.FORM_SELECT_LG : null, markup.contains(Markup.SMALL) ? BootstrapClass.FORM_SELECT_SM : null, BootstrapClass.validationColor(ComponentUtils.getMaximumSeverity(component)), component.getCustomClass());
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        SelectOneChoiceRenderer.renderFocus(clientId, ((AbstractUISelectOneBase)component).isFocus(), ((AbstractUISelectOneBase)component).isError(), facesContext, writer);
        this.renderSelectItems((UIInput)component, null, items, component.getValue(), (String)component.getSubmittedValue(), writer, facesContext);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SELECT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUISelectOneChoice)component).getFieldId(facesContext);
    }
}

