/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlBody;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PanelPartialRootRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class BodyRenderer
extends PanelPartialRootRenderer {
    private PropertyKey _firstClickPassedKey;
    private PropertyKey _initialFocusIdKey;
    private PropertyKey _onloadKey;
    private PropertyKey _onunloadKey;
    private static final String _PARTIAL_ONUNLOAD_HANDLER = "_partialUnload()";
    private static final String _VERSION_COMMENT = "Created by Apache Trinidad ";
    private static final String _PPR_BACK_UNLOAD_SCRIPT = "_savePageStateIE()";
    private static final String _PPR_BACK_CONTENT_ID = "_pprPageContent";
    private static final String _PPR_BACK_SAVE_CONTENT_ID = "_pprSavePage";
    private static final String _PPR_BACK_SAVE_SCRIPT_ID = "_pprSaveScript";
    private static final String _PPR_BACK_SAVE_LIBRARY_ID = "_pprSaveLib";

    public BodyRenderer() {
        this(HtmlBody.TYPE);
    }

    protected BodyRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._firstClickPassedKey = type.findKey("firstClickPassed");
        this._initialFocusIdKey = type.findKey("initialFocusId");
        this._onloadKey = type.findKey("onload");
        this._onunloadKey = type.findKey("onunload");
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("body", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        super.encodeAll(context, arc, component, bean);
        BodyRenderer._writeVersionInformation(context, arc);
    }

    protected void renderAtEnd(FacesContext context, RenderingContext arc) throws IOException {
        BodyRenderer._encodeServiceScripts(context);
        context.getResponseWriter().endElement("body");
        this._renderInitialFocusScript(context, arc);
    }

    protected void renderPPRSupport(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        super.renderPPRSupport(context, arc, component, bean);
        if (this.getFirstClickPassed(bean)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", null);
            BodyRenderer.renderScriptDeferAttribute(context, arc);
            BodyRenderer.renderScriptTypeAttribute(context, arc);
            writer.writeText((Object)"var _pprFirstClickPass=true;", null);
            writer.endElement("script");
        }
    }

    protected void renderContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        boolean isPartialPass = PartialPageUtils.isPartialRenderingPass(arc);
        this._renderAnchorForTop(context);
        if (BodyRenderer.supportsScripting(arc)) {
            this._renderNoScript(context, arc);
            this._storeInitialFocus(arc, bean);
        }
        if (!isPartialPass) {
            BodyRenderer._renderPartialBackSupportSpan(context, arc, true);
        }
        super.renderContent(context, arc, component, bean);
        if (!isPartialPass) {
            BodyRenderer._renderPartialBackSupportSpan(context, arc, false);
        }
    }

    protected void renderEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        super.renderEventHandlers(context, bean);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        ResponseWriter rw = context.getResponseWriter();
        if (PartialPageUtils.isPartialRenderingPass(arc)) {
            rw.writeAttribute("onunload", (Object)_PARTIAL_ONUNLOAD_HANDLER, null);
        } else {
            rw.writeAttribute("onload", (Object)this.getOnload(arc, bean), "onload");
            rw.writeAttribute("onunload", (Object)this.getOnunload(arc, bean), "onunload");
            if (BodyRenderer._isPartialBackSupported(arc)) {
                rw.writeAttribute("onbeforeunload", (Object)_PPR_BACK_UNLOAD_SCRIPT, null);
            }
        }
    }

    protected boolean getFirstClickPassed(FacesBean bean) {
        if (this._firstClickPassedKey == null) {
            return false;
        }
        Object o = bean.getProperty(this._firstClickPassedKey);
        if (o == null) {
            o = this._firstClickPassedKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getInitialFocusId(FacesBean bean) {
        return BodyRenderer.toString((Object)bean.getProperty(this._initialFocusIdKey));
    }

    protected String getOnload(RenderingContext arc, FacesBean bean) {
        String onload = this._onloadKey == null ? null : BodyRenderer.toString((Object)bean.getProperty(this._onloadKey));
        String checkLoad = "";
        if (PartialPageUtils.supportsPartialRendering(arc)) {
            checkLoad = "_checkLoad()";
        } else if (BodyRenderer.supportsNavigation(arc) || BodyRenderer.supportsEditing(arc)) {
            checkLoad = "_checkLoadNoPPR()";
        }
        onload = XhtmlUtils.getChainedJS(checkLoad, onload, false);
        return onload;
    }

    protected String getOnunload(RenderingContext arc, FacesBean bean) {
        String onunload = this._onunloadKey == null ? null : BodyRenderer.toString((Object)bean.getProperty(this._onunloadKey));
        if (PartialPageUtils.supportsPartialRendering(arc)) {
            onunload = XhtmlUtils.getChainedJS("_checkUnload(event)", onunload, false);
        }
        return onunload;
    }

    private void _renderAnchorForTop(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("name", (Object)"top", null);
        writer.endElement("a");
    }

    private void _renderNoScript(FacesContext context, RenderingContext arc) throws IOException {
        if (!BodyRenderer.isInaccessibleMode((RenderingContext)arc) && !Beans.isDesignTime()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("noscript", null);
            String message = arc.getTranslatedString("NO_SCRIPT_MESSAGE");
            writer.writeText((Object)message, null);
            writer.endElement("noscript");
        }
    }

    private void _storeInitialFocus(RenderingContext arc, FacesBean bean) {
        if (!BodyRenderer.isInaccessibleMode((RenderingContext)arc) || !BodyRenderer.supportsScripting(arc)) {
            return;
        }
        String initialFocusID = this.getInitialFocusId(bean);
        if (initialFocusID != null) {
            arc.getProperties().put(XhtmlConstants.INITIAL_FOCUS_CONTEXT_PROPERTY, initialFocusID);
        }
    }

    private void _renderInitialFocusScript(FacesContext context, RenderingContext arc) throws IOException {
        if (!BodyRenderer.isInaccessibleMode((RenderingContext)arc) || !BodyRenderer.supportsScripting(arc)) {
            return;
        }
        String initialFocusID = (String)arc.getProperties().get(XhtmlConstants.INITIAL_FOCUS_CONTEXT_PROPERTY);
        if (initialFocusID != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", null);
            XhtmlRenderer.renderScriptTypeAttribute(context, arc);
            writer.writeText((Object)"_initialFocusID='", null);
            writer.writeText((Object)initialFocusID, null);
            writer.writeText((Object)"';", null);
            writer.endElement("script");
        }
    }

    private static void _renderPartialBackSupportSpan(FacesContext context, RenderingContext arc, boolean isStart) throws IOException {
        if (BodyRenderer._isPartialBackSupported(arc)) {
            ResponseWriter writer = context.getResponseWriter();
            if (isStart) {
                writer.startElement("span", null);
                writer.writeAttribute("id", (Object)_PPR_BACK_CONTENT_ID, null);
            } else {
                writer.endElement("span");
                BodyRenderer._renderPartialBackSupportHiddenFields(writer, _PPR_BACK_SAVE_LIBRARY_ID);
                BodyRenderer._renderPartialBackSupportHiddenFields(writer, _PPR_BACK_SAVE_SCRIPT_ID);
                BodyRenderer._renderPartialBackSupportHiddenFields(writer, _PPR_BACK_SAVE_CONTENT_ID);
            }
        }
    }

    private static void _renderPartialBackSupportHiddenFields(ResponseWriter writer, String fieldName) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)fieldName, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        writer.endElement("input");
    }

    private static boolean _isPartialBackSupported(RenderingContext arc) {
        return false;
    }

    private static void _writeVersionInformation(FacesContext context, RenderingContext arc) throws IOException {
        Skin skin;
        String skinId;
        String comment = _VERSION_COMMENT;
        Class<BodyRenderer> implClass = BodyRenderer.class;
        Package implPkg = implClass.getPackage();
        Class<FacesBean> apiClass = FacesBean.class;
        Package apiPkg = apiClass.getPackage();
        String versionInfo = BodyRenderer._getVersionInfo(apiPkg, implPkg);
        comment = comment + versionInfo;
        String accessibilityMode = null;
        if (BodyRenderer.isInaccessibleMode((RenderingContext)arc)) {
            accessibilityMode = "disabled";
        } else if (BodyRenderer.isScreenReaderMode((RenderingContext)arc)) {
            accessibilityMode = "enhanced";
        }
        if (accessibilityMode != null) {
            comment = comment + ", Accessibility:" + accessibilityMode;
        }
        if ((skinId = (skin = arc.getSkin()).getId()) != null) {
            comment = comment + ", skin:" + skinId;
            RequestContext requestContext = RequestContext.getCurrentInstance();
            String preferredSkin = requestContext.getSkinFamily();
            if (preferredSkin != null) {
                comment = comment + " (" + preferredSkin + ")";
            }
        }
        context.getResponseWriter().writeComment((Object)comment);
    }

    private static void _encodeServiceScripts(FacesContext context) throws IOException {
        ExtendedRenderKitService service = (ExtendedRenderKitService)Service.getRenderKitService((FacesContext)context, ExtendedRenderKitService.class);
        if (service != null) {
            service.encodeScripts(context);
        }
    }

    private static String _getVersionInfo(Package apiPackage, Package implPackage) {
        String temp;
        String versionInfo = "";
        String apiSpecTitle = "Apache Trinidad API";
        String implSpecTitle = "Apache Trinidad Implementation";
        String apiVersion = "??";
        String implVersion = "??";
        if (apiPackage == null && implPackage == null) {
            return "(Version unknown)";
        }
        if (apiPackage != null) {
            temp = apiPackage.getSpecificationTitle();
            apiSpecTitle = temp != null ? temp : apiSpecTitle;
            temp = apiPackage.getImplementationVersion();
            String string = apiVersion = temp != null ? temp : apiVersion;
        }
        if (implPackage != null) {
            temp = implPackage.getSpecificationTitle();
            implSpecTitle = temp != null ? temp : implSpecTitle;
            temp = implPackage.getImplementationVersion();
            String string = implVersion = temp != null ? temp : implVersion;
        }
        if (apiVersion == "??" || implVersion == "??") {
            versionInfo = "Version unknown: ";
        } else if (apiVersion != "??" && implVersion != "??" && !apiVersion.equals(implVersion)) {
            versionInfo = "Version mismatch: ";
        }
        return "(" + versionInfo + apiSpecTitle + " - " + apiVersion + "/" + implSpecTitle + " - " + implVersion + ")";
    }
}

