/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.awt.Color;
import java.util.Map;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequest;
import org.apache.myfaces.trinidadinternal.image.cache.CacheKey;
import org.apache.myfaces.trinidadinternal.image.cache.CacheUtils;
import org.apache.myfaces.trinidadinternal.image.laf.browser.CompositeButtonPainter;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeButtonKey
implements ImageProviderRequest,
CacheKey,
ImageConstants {
    public static final char ACCESS_KEY_UNDEFINED = '\uffff';
    private String _lookAndFeelId;
    private String _text;
    private Color _foreground;
    private Color _background;
    private Color _surroundingColor;
    private FontProxy _font;
    private boolean _disabled;
    private boolean _textAntialias;
    private char _accessKey;
    private int _direction;
    private String _name;
    private InputStreamProvider _startIcon;
    private InputStreamProvider _endIcon;
    private InputStreamProvider _topBackgroundIcon;
    private InputStreamProvider _bottomBackgroundIcon;
    private static final int _MAP_SIZE = 14;

    public CompositeButtonKey(ImageContext context, Map<Object, Object> properties) {
        String lookAndFeelId = (String)properties.get(LOOK_AND_FEEL_ID_KEY);
        String text = (String)properties.get(TEXT_KEY);
        Color foreground = (Color)properties.get(FOREGROUND_KEY);
        Color background = (Color)properties.get(BACKGROUND_KEY);
        Color surroundingColor = (Color)properties.get(SURROUNDING_COLOR_KEY);
        FontProxy font = CacheUtils.getSharedFont(properties, FONT_KEY);
        int direction = CacheUtils.getReadingDirection(context, properties);
        boolean disabled = CacheUtils.getBoolean(properties, DISABLED_KEY, false);
        boolean textAntialias = CacheUtils.isTextAntialiased(properties);
        char accessKey = this._getChar(properties, ACCESS_KEY_KEY);
        String name = (String)properties.get(NAME_KEY);
        InputStreamProvider startIcon = this._getIcon(properties, BUTTON_START_ICON_KEY);
        InputStreamProvider endIcon = this._getIcon(properties, BUTTON_END_ICON_KEY);
        InputStreamProvider topBackgroundIcon = this._getIcon(properties, BUTTON_TOP_BACKGROUND_ICON_KEY);
        InputStreamProvider bottomBackgroundIcon = this._getIcon(properties, BUTTON_BOTTOM_BACKGROUND_ICON_KEY);
        this._init(context, lookAndFeelId, name, text, foreground, background, surroundingColor, font, direction, disabled, textAntialias, accessKey, startIcon, endIcon, topBackgroundIcon, bottomBackgroundIcon);
    }

    public CompositeButtonKey(ImageContext context, String lookAndFeelId, String name, String text, Color foreground, Color background, Color surroundingColor, FontProxy font, boolean disabled, boolean textAntialias, char accessKey, InputStreamProvider startIcon, InputStreamProvider endIcon, InputStreamProvider topBackgroundIcon, InputStreamProvider bottomBackgroundIcon) {
        this._init(context, lookAndFeelId, name, text, foreground, background, surroundingColor, font, CacheUtils.getReadingDirection(context, null), disabled, textAntialias, accessKey, startIcon, endIcon, topBackgroundIcon, bottomBackgroundIcon);
    }

    @Override
    public String getNamespaceURI() {
        return "http://myfaces.apache.org/uix/image";
    }

    @Override
    public String getLocalName() {
        return "compositeButton";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeButtonKey)) {
            return false;
        }
        CompositeButtonKey key = (CompositeButtonKey)o;
        boolean isEqual = this._lookAndFeelId.equals(key._lookAndFeelId) && this._text.equals(key._text) && this._foreground.equals(key._foreground) && this._background.equals(key._background) && this._surroundingColor.equals(key._surroundingColor) && this._fontEquals(key._font) && this._direction == key._direction && this._disabled == key._disabled && this._textAntialias == key._textAntialias && this._accessKey == key._accessKey;
        return isEqual;
    }

    public int hashCode() {
        int fontHash = this._font.getStyle() ^ this._font.getSize();
        return this._lookAndFeelId.hashCode() ^ this._text.hashCode() ^ this._foreground.hashCode() ^ this._background.hashCode() ^ this._surroundingColor.hashCode() ^ fontHash ^ this._accessKey;
    }

    @Override
    public Map<Object, Object> getRenderProperties(ImageContext context) {
        ArrayMap properties = new ArrayMap(14);
        properties.put(LOOK_AND_FEEL_ID_KEY, (Object)this._lookAndFeelId);
        properties.put(NAME_KEY, (Object)this._name);
        properties.put(TEXT_KEY, (Object)this._text);
        properties.put(FOREGROUND_KEY, (Object)this._foreground);
        properties.put(BACKGROUND_KEY, (Object)this._background);
        properties.put(SURROUNDING_COLOR_KEY, (Object)this._surroundingColor);
        properties.put(FONT_KEY, (Object)this._font);
        CacheUtils.putBoolean((Map<Object, Object>)properties, DISABLED_KEY, this._disabled);
        CacheUtils.putBoolean((Map<Object, Object>)properties, TEXT_ANTIALIAS_KEY, this._textAntialias);
        this._putChar((Map<Object, Object>)properties, ACCESS_KEY_KEY, this._accessKey);
        this._putStartIcon((Map<Object, Object>)properties);
        this._putEndIcon((Map<Object, Object>)properties);
        this._putTopBackgroundIcon((Map<Object, Object>)properties);
        this._putBottomBackgroundIcon((Map<Object, Object>)properties);
        return properties;
    }

    protected InputStreamProvider getStartIcon() {
        return null;
    }

    protected InputStreamProvider getEndIcon() {
        return null;
    }

    protected InputStreamProvider getTopBackgroundIcon() {
        return null;
    }

    protected InputStreamProvider getBottomBackgroundIcon() {
        return null;
    }

    public String toString() {
        String propertiesString = "lookAndFeelId=" + this._lookAndFeelId + "text=" + this._text + ",foreground=" + this._foreground + ",background=" + this._background + ",surroundingColor=" + this._surroundingColor + ",font=" + this._font + ",disabled=" + this._disabled + ",textAntialias=" + this._textAntialias + ",accessKey=" + this._accessKey;
        return this.getClass().getName() + "[" + propertiesString + "]";
    }

    public final String getName() {
        return this._name;
    }

    public final String getText() {
        return this._text;
    }

    public final Color getForeground() {
        return this._foreground;
    }

    public final Color getBackground() {
        return this._background;
    }

    public final FontProxy getFont() {
        return this._font;
    }

    public final int getDirection() {
        return this._direction;
    }

    public final char getAccessKey() {
        return this._accessKey;
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public final boolean isTextAntialiased() {
        return this._textAntialias;
    }

    protected void setName(String name) {
        this._name = name;
    }

    protected void setText(String text) {
        this._text = text;
    }

    protected void setForeground(Color foreground) {
        this._foreground = foreground;
    }

    protected void setBackground(Color background) {
        this._background = background;
    }

    protected void setFont(FontProxy font) {
        this._font = font;
    }

    protected void setDirection(int direction) {
        this._direction = direction;
    }

    protected void setAccessKey(char accessKey) {
        this._setAccessKey(accessKey);
    }

    protected void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    protected void setTextAntialiased(boolean textAntialiased) {
        this._textAntialias = textAntialiased;
    }

    private void _init(ImageContext context, String lookAndFeelId, String name, String text, Color foreground, Color background, Color surroundingColor, FontProxy font, int direction, boolean disabled, boolean textAntialias, char accessKey, InputStreamProvider startIcon, InputStreamProvider endIcon, InputStreamProvider topBackgroundIcon, InputStreamProvider bottomBackgroundIcon) {
        this._lookAndFeelId = lookAndFeelId;
        this._name = name;
        this._text = text == null ? "" : text;
        this._foreground = this._getForeground(context, foreground, disabled);
        this._background = this._getBackground(context, background, disabled);
        this._surroundingColor = this._getSurroundingColor(surroundingColor);
        this._font = this._getFont(font);
        this._direction = direction;
        this._disabled = disabled;
        this._textAntialias = textAntialias;
        this._setAccessKey(accessKey);
        this._startIcon = startIcon;
        this._endIcon = endIcon;
        this._topBackgroundIcon = topBackgroundIcon;
        this._bottomBackgroundIcon = bottomBackgroundIcon;
    }

    private char _getChar(Map<Object, Object> properties, Object key) {
        Character value = (Character)properties.get(key);
        if (value == null) {
            return '\uffff';
        }
        return value.charValue();
    }

    private void _putChar(Map<Object, Object> properties, Object key, char value) {
        if (value != '\uffff') {
            properties.put(key, Character.valueOf(value));
        }
    }

    private Color _getForeground(ImageContext context, Color foreground, boolean disabled) {
        if (foreground != null) {
            return foreground;
        }
        return CompositeButtonPainter.getDefaultForeground(context, disabled);
    }

    private Color _getBackground(ImageContext context, Color background, boolean disabled) {
        if (background != null) {
            return background;
        }
        return CompositeButtonPainter.getDefaultBackground(context, disabled);
    }

    private Color _getSurroundingColor(Color color) {
        if (color == null || color.getAlpha() == 0) {
            return CacheUtils.TRANSPARENT_COLOR;
        }
        return color;
    }

    private FontProxy _getFont(FontProxy font) {
        if (font != null) {
            return font;
        }
        return CompositeButtonPainter.getDefaultFont();
    }

    private void _setAccessKey(char accessKey) {
        this._accessKey = Character.toLowerCase(accessKey);
    }

    private boolean _fontEquals(FontProxy font) {
        if (this._font.getName() == null || font.getName() == null) {
            return this._font.getStyle() == font.getStyle() && this._font.getSize() == font.getSize();
        }
        return this._font.equals(font);
    }

    private InputStreamProvider _getIcon(Map<Object, Object> properties, Object iconKey) {
        return (InputStreamProvider)properties.get(iconKey);
    }

    private void _putStartIcon(Map<Object, Object> properties) {
        if (this._startIcon == null) {
            this._startIcon = this.getStartIcon();
        }
        if (this._startIcon != null) {
            properties.put(BUTTON_START_ICON_KEY, this._startIcon);
        }
    }

    private void _putEndIcon(Map<Object, Object> properties) {
        if (this._endIcon == null) {
            this._endIcon = this.getEndIcon();
        }
        if (this._endIcon != null) {
            properties.put(BUTTON_END_ICON_KEY, this._endIcon);
        }
    }

    private void _putTopBackgroundIcon(Map<Object, Object> properties) {
        if (this._topBackgroundIcon == null) {
            this._topBackgroundIcon = this.getTopBackgroundIcon();
        }
        if (this._topBackgroundIcon != null) {
            properties.put(BUTTON_TOP_BACKGROUND_ICON_KEY, this._topBackgroundIcon);
        }
    }

    private void _putBottomBackgroundIcon(Map<Object, Object> properties) {
        if (this._bottomBackgroundIcon == null) {
            this._bottomBackgroundIcon = this.getBottomBackgroundIcon();
        }
        if (this._bottomBackgroundIcon != null) {
            properties.put(BUTTON_BOTTOM_BACKGROUND_ICON_KEY, this._bottomBackgroundIcon);
        }
    }
}

