/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen;

import java.beans.Beans;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.util.FileUtils;
import org.apache.myfaces.trinidadinternal.skin.pregen.AllVariantsSkinPregenerator;
import org.apache.myfaces.trinidadinternal.skin.pregen.SkinPregenerator;
import org.apache.myfaces.trinidadinternal.skin.pregen.config.PregenConfig;
import org.apache.myfaces.trinidadinternal.skin.pregen.context.PregenStyleProvider;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;

public final class SkinPregenerationUtils {
    private static final SkinPregenerator _NOOP_PREGENERATOR = new SkinPregenerator(){

        @Override
        public void pregenerate(FacesContext context, Skin skin, PregenConfig config, StyleProvider provider) {
        }
    };

    public static void pregenerate(FacesContext context, Skin skin, PregenConfig config) throws IOException {
        assert (skin != null);
        assert (config != null);
        SkinPregenerator pregenerator = SkinPregenerationUtils._getSkinPregenerator();
        String stylesCacheDirectoryPath = SkinPregenerationUtils._getStylesCacheDirectoryPath(config);
        PregenStyleProvider provider = new PregenStyleProvider(skin, stylesCacheDirectoryPath);
        pregenerator.pregenerate(context, skin, config, provider);
    }

    private static SkinPregenerator _getSkinPregenerator() {
        if (Beans.isDesignTime()) {
            return _NOOP_PREGENERATOR;
        }
        return new AllVariantsSkinPregenerator();
    }

    private static String _getStylesCacheDirectoryPath(PregenConfig config) throws IOException {
        String targetDirPath = config.getTargetDirectoryPath();
        String subDirPath = "/adf/styles/cache/";
        String stylesCacheDirPath = targetDirPath + subDirPath;
        FileUtils.toWritableDirectory((String)stylesCacheDirPath);
        return stylesCacheDirPath;
    }

    private SkinPregenerationUtils() {
    }
}

