/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.config.element;



/**
 * Entry of the Collection returned by {@link NavigationRule#getNavigationCases()}.
 *
 * @author Manfred Geiler (latest modification by $Author: mmarinschek $)
 * @version $Revision: 530668 $ $Date: 2007-04-20 01:40:54 -0500 (Fri, 20 Apr 2007) $
 */
public interface NavigationCase extends ElementBase
{
    // <!ELEMENT navigation-case (description*, display-name*, icon*, from-action?, from-outcome?, to-view-id, redirect?)>

    public String getFromAction();
    public String getFromOutcome();
    public boolean isRedirect();
    public String getToViewId();
}
