"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const chai_1 = require("chai");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const mona_dish_1 = require("mona-dish");
const Const_1 = require("../../impl/core/Const");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
var STD_XML = StandardInits_1.StandardInits.STD_XML;
let issueStdReq = function (element) {
    faces.ajax.request(element, null, {
        execute: "input_1",
        render: "@form",
        params: {
            pass1: "pass1",
            pass2: "pass2"
        }
    });
};
/**
 * specialized tests testing the xhr core behavior when it hits the xmlHttpRequest object
 */
(0, mocha_1.describe)('Tests on the xhr core when it starts to call the request', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.spy(global.faces.ajax, "response");
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    (0, mocha_1.it)('must have the standard parameters all in', function (done) {
        //issue a standard faces.ajax.request upon the standard simple form case and check the passed parameters
        //and whether send was called
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            issueStdReq(element);
            (0, chai_1.expect)(this.requests.length).to.eq(1);
            (0, chai_1.expect)(this.requests[0].method).to.eq("POST");
            (0, chai_1.expect)(this.requests[0].async).to.be.true;
            (0, chai_1.expect)(send.called).to.be.true;
            (0, chai_1.expect)(send.callCount).to.eq(1);
            //sent params jakarta.faces.ViewState=null&execute=input_1&render=%40form&pass1=pass1&pass2=pass2&jakarta.faces.windowId=null&jakarta.faces.source=input_2&jakarta.faces.partial.ajax=input_2&blarg=blarg&jakarta.faces.partial.execute=input_1%20input_2&jakarta.faces.partial.render=blarg
        }
        finally {
            send.restore();
        }
        done();
    });
    (0, mocha_1.it)('it must have the pass through values properly passed', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            issueStdReq(element);
            (0, chai_1.expect)(send.called).to.be.true;
            let argsVal = send.args[0][0];
            let arsArr = argsVal.split("&");
            let resultsMap = {};
            for (let val of arsArr) {
                let keyVal = val.split("=");
                resultsMap[keyVal[0]] = keyVal[1];
            }
            (0, chai_1.expect)(resultsMap["pass1"]).to.eq("pass1");
            (0, chai_1.expect)(resultsMap["pass2"]).to.eq("pass2");
            (0, chai_1.expect)(!!resultsMap["render"]).to.be.false;
            (0, chai_1.expect)(!!resultsMap["execute"]).to.be.false;
            (0, chai_1.expect)(Const_1.P_WINDOW_ID in resultsMap).to.be.false;
            (0, chai_1.expect)(Const_1.P_VIEWSTATE in resultsMap).to.be.true;
            (0, chai_1.expect)(resultsMap[Const_1.P_PARTIAL_SOURCE]).to.eq("input_2");
            (0, chai_1.expect)(resultsMap[Const_1.P_AJAX]).to.eq("true");
            (0, chai_1.expect)(resultsMap[Const_1.P_RENDER]).to.eq("blarg");
            (0, chai_1.expect)(resultsMap[Const_1.P_EXECUTE]).to.eq("input_1%20input_2");
        }
        finally {
            send.restore();
        }
        done();
    });
    (0, mocha_1.it)('it must handle resetValues properly', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            faces.ajax.request(element, null, {
                execute: "input_1",
                resetValues: true,
                render: "@form",
                params: {
                    pass1: "pass1",
                    pass2: "pass2"
                }
            });
            (0, chai_1.expect)(send.called).to.be.true;
            let argsVal = send.args[0][0];
            let arsArr = argsVal.split("&");
            let resultsMap = {};
            for (let val of arsArr) {
                let keyVal = val.split("=");
                resultsMap[keyVal[0]] = keyVal[1];
            }
            (0, chai_1.expect)(resultsMap["jakarta.faces.partial.resetValues"]).to.eq("true");
        }
        finally {
            send.restore();
        }
        done();
    });
    (0, mocha_1.it)('it must have the proper target type', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            issueStdReq(element);
            (0, chai_1.expect)(this.requests[0].requestHeaders.Accept.indexOf("application/xml") != -1).to.be.true;
        }
        finally {
            send.restore();
        }
        done();
    });
});
(0, mocha_1.describe)('Tests after core when it hits response', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr = sinon.useFakeXMLHttpRequest();
                // @ts-ignore
                window.XMLHttpRequest = this.xhr = sinon.useFakeXMLHttpRequest();
                this.jsfAjaxResponse = sinon.spy(global.faces.ajax, "response");
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    (0, mocha_1.it)('must have passed all ajax request phase events', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let globalCnt = 0;
        let localCnt = 0;
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            faces.ajax.addOnEvent(() => {
                globalCnt++;
            });
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                params: {
                    pass1: "pass1",
                    pass2: "pass2"
                },
                message: "Hello World",
                onevent: (evt) => {
                    localCnt++;
                }
            });
            let xhrReq = this.requests[0];
            let requestBody = xhrReq.requestBody.split("&");
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
            (0, chai_1.expect)(requestBody.indexOf("pass1=pass1")).not.to.eq(-1);
            (0, chai_1.expect)(requestBody.indexOf("pass2=pass2")).not.to.eq(-1);
            (0, chai_1.expect)(requestBody.indexOf("message=Hello%20World")).not.to.eq(-1);
            (0, chai_1.expect)(this.jsfAjaxResponse.callCount).to.eq(1);
            //success ommitted due to fake response
            (0, chai_1.expect)(globalCnt == 3).to.eq(true);
            (0, chai_1.expect)(localCnt == 3).to.eq(true);
            done();
        }
        catch (e) {
            console.error(e);
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('it must have called request and the pass through values must be properly transferred ' +
        'into the context, via the old non spec conform behavior', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let globalCnt = 0;
        let localCnt = 0;
        let xhrReq = null;
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            faces.ajax.addOnEvent(() => {
                globalCnt++;
            });
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                pass1: "pass1",
                pass2: "pass2",
                onevent: (evt) => {
                    localCnt++;
                    if (evt.status == Const_1.COMPLETE) {
                        (0, chai_1.expect)(!!xhrReq.responseXML).to.be.true;
                    }
                    if (evt.status == Const_1.SUCCESS) {
                        (0, chai_1.expect)(this.jsfAjaxResponse.callCount).to.eq(1);
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args[0] instanceof XMLHttpRequest).to.be.true;
                        let lastArg = this.jsfAjaxResponse.firstCall.args[1];
                        (0, chai_1.expect)(lastArg.onevent != null).to.be.true;
                        (0, chai_1.expect)(lastArg.onevent instanceof Function).to.be.true;
                        (0, chai_1.expect)(!!lastArg.onError).to.be.false;
                        (0, chai_1.expect)(lastArg.pass1 == "pass1").to.be.true;
                        (0, chai_1.expect)(lastArg.pass2 == "pass2").to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_PARTIAL_SOURCE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_AJAX]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_EXECUTE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_RENDER]).to.be.true;
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args.length).to.eq(2);
                        (0, chai_1.expect)(globalCnt == 2).to.eq(true); //local before global
                        (0, chai_1.expect)(localCnt == 3).to.eq(true);
                        done();
                    }
                }
            });
            xhrReq = this.requests[0];
            xhrReq.responsetype = "text/xml";
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
        }
        catch (e) {
            console.error(e);
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('it must have allow array key value pairs as passthroughs', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let globalCnt = 0;
        let localCnt = 0;
        let xhrReq = null;
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            faces.ajax.addOnEvent(() => {
                globalCnt++;
            });
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                params: [["pass1", "pass1"],
                    ["pass2", "pass2"]],
                onevent: (evt) => {
                    localCnt++;
                    if (evt.status == Const_1.COMPLETE) {
                        (0, chai_1.expect)(!!xhrReq.responseXML).to.be.true;
                    }
                    if (evt.status == Const_1.SUCCESS) {
                        (0, chai_1.expect)(this.jsfAjaxResponse.callCount).to.eq(1);
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args[0] instanceof XMLHttpRequest).to.be.true;
                        let lastArg = this.jsfAjaxResponse.firstCall.args[1];
                        (0, chai_1.expect)(lastArg.onevent != null).to.be.true;
                        (0, chai_1.expect)(lastArg.onevent instanceof Function).to.be.true;
                        (0, chai_1.expect)(!!lastArg.onError).to.be.false;
                        (0, chai_1.expect)(lastArg.pass1 == "pass1").to.be.true;
                        (0, chai_1.expect)(lastArg.pass2 == "pass2").to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_PARTIAL_SOURCE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_AJAX]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_EXECUTE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_RENDER]).to.be.true;
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args.length).to.eq(2);
                        (0, chai_1.expect)(globalCnt == 2).to.eq(true); //local before global
                        (0, chai_1.expect)(localCnt == 3).to.eq(true);
                        done();
                    }
                }
            });
            xhrReq = this.requests[0];
            xhrReq.responsetype = "text/xml";
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
        }
        catch (e) {
            console.error(e);
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('it must have called request and the pass through values must be properly transferred into the context', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let globalCnt = 0;
        let localCnt = 0;
        let xhrReq = null;
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            faces.ajax.addOnEvent(() => {
                globalCnt++;
            });
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                params: {
                    pass1: "pass1",
                    pass2: "pass2",
                },
                onevent: (evt) => {
                    localCnt++;
                    if (evt.status == Const_1.COMPLETE) {
                        (0, chai_1.expect)(!!xhrReq.responseXML).to.be.true;
                    }
                    if (evt.status == Const_1.SUCCESS) {
                        (0, chai_1.expect)(this.jsfAjaxResponse.callCount).to.eq(1);
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args[0] instanceof XMLHttpRequest).to.be.true;
                        let lastArg = this.jsfAjaxResponse.firstCall.args[1];
                        (0, chai_1.expect)(lastArg.onevent != null).to.be.true;
                        (0, chai_1.expect)(lastArg.onevent instanceof Function).to.be.true;
                        (0, chai_1.expect)(!!lastArg.onError).to.be.false;
                        (0, chai_1.expect)(lastArg.pass1 == "pass1").to.be.true;
                        (0, chai_1.expect)(lastArg.pass2 == "pass2").to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_PARTIAL_SOURCE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_AJAX]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_EXECUTE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[Const_1.P_RENDER]).to.be.true;
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args.length).to.eq(2);
                        (0, chai_1.expect)(globalCnt == 2).to.eq(true); //local before global
                        (0, chai_1.expect)(localCnt == 3).to.eq(true);
                        done();
                    }
                }
            });
            xhrReq = this.requests[0];
            xhrReq.responsetype = "text/xml";
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
        }
        catch (e) {
            console.error(e);
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('it must have called onError in the error case', function (done) {
        //on hold until it is clear why sinon is not giving me the response XML as expected
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let xhrReq = null;
        try {
            let errorCnt = 0;
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                params: {
                    pass1: "pass1",
                    pass2: "pass2",
                },
                onerror: (error) => {
                    var _a;
                    (0, chai_1.expect)(error.type).to.eq("error");
                    (0, chai_1.expect)(error.status).to.eq(Const_1.EMPTY_STR);
                    (0, chai_1.expect)(!!error.message).to.eq(true);
                    (0, chai_1.expect)(!!((_a = error.source) === null || _a === void 0 ? void 0 : _a.id)).to.eq(true);
                    (0, chai_1.expect)(!!error.responseCode).to.eq(true);
                    (0, chai_1.expect)(!!error.responseText).to.eq(true);
                    (0, chai_1.expect)(!error.responseXML).to.eq(true);
                    done();
                },
                onevent: (evt) => {
                    if (evt.status == Const_1.COMPLETE) {
                        throw Error("This error is wanted, ignore the log");
                    }
                }
            });
            xhrReq = this.requests[0];
            xhrReq.responsetype = "text/xml";
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
        }
        catch (e) {
            console.error(e);
        }
        finally {
            send.restore();
        }
    });
    // We can cover this TCK issue in a simple code unit test, the case is simple enough
    (0, mocha_1.it)("must throw an error on invalid delays (MYFACES-4499, TCK_ISSUE320IT )", (done) => {
        let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
        try {
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                delay: NaN,
                params: {
                    pass1: "pass1",
                    pass2: "pass2",
                }
            });
        }
        catch (e) {
            (0, chai_1.expect)(e.message.indexOf("NaN") > 0).to.eq(true, "Invalid NaN in message");
            done();
            return;
        }
        done("Expecting a client error to be thrown");
    });
    (0, mocha_1.it)("must throw an error on invalid delays (MYFACES-4499, TCK_ISSUE320IT ) - 2", (done) => {
        let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
        try {
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                delay: -1,
                params: {
                    pass1: "pass1",
                    pass2: "pass2",
                }
            });
        }
        catch (e) {
            (0, chai_1.expect)(e.message.indexOf("-1") > 0).to
                .eq(true, "Invalid integer value in message");
            done();
            return;
        }
        done("Expecting a client error to be thrown");
    });
    (0, mocha_1.it)("must throw an error on invalid delays (MYFACES-4499, TCK_ISSUE320IT ) - 3", (done) => {
        let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
        try {
            faces.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                delay: "booga",
                params: {
                    pass1: "pass1",
                    pass2: "pass2",
                }
            });
        }
        catch (e) {
            (0, chai_1.expect)(e.message.indexOf("booga") > 0).to.be
                .eq(true, "Invalid string value in message");
            done();
            return;
        }
        done("Expecting a client error to be thrown");
    });
});
//# sourceMappingURL=RequestTest.spec.js.map