<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">

    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>4.0.0</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <modelVersion>4.0.0</modelVersion>

    <artifactId>myfaces-bundle</artifactId>
    <name>Apache MyFaces Core 4.0 - OSGi Bundle</name>
    <packaging>bundle</packaging>

    <build>
        <plugins>
            <plugin>
                <groupId>org.apache.felix</groupId>
                <artifactId>maven-bundle-plugin</artifactId>
                <extensions>true</extensions>
                <configuration>
                    <instructions>
                        <Bundle-SymbolicName>org.apache.myfaces.core.bundle</Bundle-SymbolicName>
                        <Build-Jdk>${java.version}</Build-Jdk>
                        <Implementation-Title>${project.name}</Implementation-Title>
                        <Implementation-Version>${project.version}</Implementation-Version>
                        <Implementation-Vendor>The Apache Software Foundation</Implementation-Vendor>
                        <Implementation-Vendor-Id>${project.groupId}</Implementation-Vendor-Id>
                        <Export-Package>
                            jakarta.faces.*;version="${project.version}",
                            org.apache.myfaces.core.api.shared.lang.*;version="${project.version}",
                            org.apache.myfaces.application.*;version="${project.version}",
                            org.apache.myfaces.cdi.*;version="${project.version}",
                            org.apache.myfaces.component.*;version="${project.version}",
                            org.apache.myfaces.config.*;version="${project.version}",
                            org.apache.myfaces.context.*;version="${project.version}",
                            org.apache.myfaces.el.*;version="${project.version}",
                            org.apache.myfaces.event.*;version="${project.version}",
                            org.apache.myfaces.flow.*;version="${project.version}",
                            org.apache.myfaces.lifecycle.*;version="${project.version}",
                            org.apache.myfaces.push.*;version="${project.version}",
                            org.apache.myfaces.renderkit.*;version="${project.version}",
                            org.apache.myfaces.resource.*;version="${project.version}",
                            org.apache.myfaces.spi.*;version="${project.version}",
                            org.apache.myfaces.util.*;version="${project.version}",
                            org.apache.myfaces.view.*;version="${project.version}",
                            org.apache.myfaces.webapp.*;version="${project.version}"
                        </Export-Package>
                        <Import-Package>
                            !org.apache.myfaces.*,
                            com.google.inject;version="[1.0.0, 2.0.0)";resolution:=optional,
                            jakarta.annotation;version="[2.1.0, 3.0.0)",
                            javax.crypto,
                            javax.crypto.spec,
                            jakarta.ejb;version="[4.0.0, 5.0.0)";resolution:=optional,
                            jakarta.el;version="[5.0.0, 6.0.0)",
                            javax.naming,
                            jakarta.persistence;version="[3.1.0, 4.0.0)";resolution:=optional,
                            javax.portlet;version="[1.0.0, 2.1)";resolution:=optional,                            
                            jakarta.servlet;version="[6.0.0, 7.0.0)",
                            jakarta.servlet.http;version="[6.0.0, 7.0.0)",
                            jakarta.servlet.annotation;version="[6.0.0, 7.0.0)";resolution:=optional,
                            jakarta.validation*;version="[3.0.0, 4.0.0)",
                            jakarta.inject,
                            jakarta.enterprise.util,
                            jakarta.enterprise.context,
                            jakarta.enterprise.context.spi,
                            jakarta.enterprise.inject,
                            jakarta.enterprise.inject.spi,
                            jakarta.enterprise.event,
                            javax.xml.parsers,
                            org.apache;resolution:=optional,
                            org.w3c.dom,
                            org.xml.sax,
                            org.xml.sax.helpers,
                            org.apache.jasper.compiler;resolution:=optional,
                            org.apache.jasper.el;resolution:=optional,
                            org.apache.el;resolution:=optional,
                            org.apache.tomcat;resolution:=optional,
                            *
                        </Import-Package>
                        <Embed-Dependency>*;type=!pom;inline=true</Embed-Dependency>
                    </instructions>
                </configuration>
            </plugin>
        </plugins>
    </build>


    <dependencies>
        <!-- include myfaces-api and myfaces-impl in the bundle -->
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-api</artifactId>
            <version>${project.version}</version>
            <scope>provided</scope>
        </dependency>
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-impl</artifactId>
            <version>${project.version}</version>
            <scope>provided</scope>
        </dependency>
        
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-jcdi_2.0_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-atinject_1.0_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-annotation_1.3_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-servlet-api</artifactId>
        </dependency>
    </dependencies>

</project>
