/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.jvm;

import java.util.EnumSet;
import java.util.Set;
import jpt.sun.tools.javac.jvm.Target;
import jpt.sun.tools.javac.main.Option;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.Options;

public enum Profile {
    COMPACT1("compact1", 1, Target.JDK1_8, new Target[0]),
    COMPACT2("compact2", 2, Target.JDK1_8, new Target[0]),
    COMPACT3("compact3", 3, Target.JDK1_8, new Target[0]),
    DEFAULT{

        @Override
        public boolean isValid(Target t) {
            return true;
        }
    };

    private static final Context.Key<Profile> profileKey;
    public final String name;
    public final int value;
    final Set<Target> targets;

    public static Profile instance(Context context) {
        Profile instance = context.get(profileKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String profileString = options.get(Option.PROFILE);
            if (profileString != null) {
                instance = Profile.lookup(profileString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(profileKey, instance);
        }
        return instance;
    }

    private Profile() {
        this.name = null;
        this.value = Integer.MAX_VALUE;
        this.targets = null;
    }

    private Profile(String name, int value, Target t, Target ... targets) {
        this.name = name;
        this.value = value;
        this.targets = EnumSet.of(t, targets);
    }

    public static Profile lookup(String name) {
        for (Profile p : Profile.values()) {
            if (!name.equals(p.name)) continue;
            return p;
        }
        return null;
    }

    public static Profile lookup(int value) {
        for (Profile p : Profile.values()) {
            if (value != p.value) continue;
            return p;
        }
        return null;
    }

    public boolean isValid(Target t) {
        return this.targets.contains((Object)t);
    }

    static {
        profileKey = new Context.Key();
    }
}

