/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.LinkedList;
import java.util.List;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public final class MultipleLoggers {
    public static Iterable<ErrorDescription> checkMultipleLoggers(HintContext ctx) {
        Element cls = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (cls == null || cls.getKind() != ElementKind.CLASS || cls.getModifiers().contains((Object)Modifier.ABSTRACT) || cls.getEnclosingElement() != null && cls.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return null;
        }
        TypeElement loggerTypeElement = ctx.getInfo().getElements().getTypeElement("java.util.logging.Logger");
        if (loggerTypeElement == null) {
            return null;
        }
        TypeMirror loggerTypeElementAsType = loggerTypeElement.asType();
        if (loggerTypeElementAsType == null || loggerTypeElementAsType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        LinkedList<VariableElement> loggerFields = new LinkedList<VariableElement>();
        List<VariableElement> fields = ElementFilter.fieldsIn(cls.getEnclosedElements());
        for (VariableElement variableElement : fields) {
            if (variableElement.getKind() != ElementKind.FIELD || !variableElement.asType().equals(loggerTypeElementAsType)) continue;
            loggerFields.add(variableElement);
        }
        if (loggerFields.size() > 1) {
            StringBuilder loggers = new StringBuilder();
            for (VariableElement variableElement : loggerFields) {
                int[] span;
                Tree tree = ctx.getInfo().getTrees().getTree(variableElement);
                if (!(tree instanceof VariableTree) || (span = ctx.getInfo().getTreeUtilities().findNameSpan((VariableTree)tree)) == null) continue;
                if (loggers.length() > 0) {
                    loggers.append(", ");
                }
                loggers.append(variableElement.getSimpleName().toString());
            }
            LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
            for (VariableElement variableElement : loggerFields) {
                Tree path = ctx.getInfo().getTrees().getTree(variableElement);
                ErrorDescription ed = ErrorDescriptionFactory.forName(ctx, path, NbBundle.getMessage(MultipleLoggers.class, "MSG_MultipleLoggers_checkMultipleLoggers", loggers, cls), new Fix[0]);
                linkedList.add(ed);
            }
            return linkedList;
        }
        return null;
    }
}

