/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.LazyProjectInitializing;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

final class LazyProject
implements Project,
ProjectInformation,
LogicalViewProvider,
RecommendedTemplates {
    URL url;
    String displayName;
    ExtIcon icon;

    public LazyProject(URL url, String displayName, ExtIcon icon) {
        this.url = url;
        this.displayName = displayName;
        this.icon = icon;
    }

    @Override
    public FileObject getProjectDirectory() {
        FileObject fo = URLMapper.findFileObject(this.url);
        if (fo == null) {
            OpenProjectList.LOGGER.warning("Project dir with " + this.url + " not found!");
            fo = FileUtil.createMemoryFileSystem().getRoot();
        }
        return fo;
    }

    @Override
    public Lookup getLookup() {
        return Lookups.fixed(this);
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Icon getIcon() {
        return this.icon.getIcon();
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public Node createLogicalView() {
        return new ProjNode(Lookups.singleton(this));
    }

    @Override
    public Node findPath(Node root, Object target) {
        return null;
    }

    @Override
    public String[] getRecommendedTypes() {
        return new String[]{"simple-files"};
    }

    private final class ProjCh
    extends Children.Array {
        private ProjCh() {
        }

        @Override
        protected Collection<Node> initCollection() {
            AbstractNode n = new AbstractNode(Children.LEAF);
            n.setName("init");
            n.setDisplayName(NbBundle.getMessage(ProjCh.class, "MSG_ProjChInit"));
            n.setIconBaseWithExtension("org/netbeans/modules/project/ui/resources/wait.gif");
            return Collections.singletonList(n);
        }

        @Override
        protected void addNotify() {
            super.addNotify();
            OpenProjectList.preferredProject(LazyProject.this);
        }
    }

    private final class ProjNode
    extends AbstractNode {
        public ProjNode(Lookup lookup) {
            super(new ProjCh(), lookup);
            this.setName(LazyProject.this.url.toExternalForm());
            this.setDisplayName(LazyProject.this.displayName);
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.icon2Image(LazyProject.this.icon.getIcon());
        }

        @Override
        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        @Override
        public Action getPreferredAction() {
            OpenProjectList.preferredProject(LazyProject.this);
            return super.getPreferredAction();
        }

        @Override
        public boolean hasCustomizer() {
            return false;
        }

        @Override
        public Action[] getActions(boolean context) {
            OpenProjectList.preferredProject(LazyProject.this);
            return new Action[]{SystemAction.get(LazyProjectInitializing.class), CommonProjectActions.closeProjectAction()};
        }
    }
}

