/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractDataFrameCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.IntervalBwdDataFrameCursor;
import io.questdb.cairo.IntervalFwdDataFrameCursor;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.Misc;

public class IntervalFwdDataFrameCursorFactory
extends AbstractDataFrameCursorFactory {
    private final IntervalFwdDataFrameCursor cursor;
    private final RuntimeIntrinsicIntervalModel intervals;
    private IntervalBwdDataFrameCursor bwdCursor;

    public IntervalFwdDataFrameCursorFactory(TableToken tableToken, int tableId, long tableVersion, RuntimeIntrinsicIntervalModel intervals, int timestampIndex, GenericRecordMetadata metadata) {
        super(tableToken, tableVersion, metadata);
        this.cursor = new IntervalFwdDataFrameCursor(intervals, timestampIndex);
        this.intervals = intervals;
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.intervals);
    }

    @Override
    public DataFrameCursor getCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        if (order == 0 || order == 2) {
            this.cursor.of(this.getReader(executionContext), executionContext);
            return this.cursor;
        }
        if (this.bwdCursor == null) {
            this.bwdCursor = new IntervalBwdDataFrameCursor(this.intervals, this.cursor.getTimestampIndex());
        }
        return this.bwdCursor.of(this.getReader(executionContext), executionContext);
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void toPlan(PlanSink sink) {
        if (sink.getOrder() == 1) {
            sink.type("Interval backward scan");
        } else {
            sink.type("Interval forward scan");
        }
        super.toPlan(sink);
        sink.attr("intervals").val(this.intervals);
    }
}

