/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.model.AliasTranslator;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.WithClauseModel;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.ObjectPool;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;

public class QueryModel
implements Mutable,
ExecutionModel,
AliasTranslator,
Sinkable {
    public static final QueryModelFactory FACTORY = new QueryModelFactory();
    public static final int JOIN_ASOF = 4;
    public static final int JOIN_CROSS = 3;
    public static final int JOIN_CROSS_LEFT = 8;
    public static final int JOIN_INNER = 1;
    public static final int JOIN_LT = 6;
    public static final int JOIN_MAX = 8;
    public static final int JOIN_ONE = 7;
    public static final int JOIN_OUTER = 2;
    public static final int JOIN_SPLICE = 5;
    public static final int LATEST_BY_DEPRECATED = 1;
    public static final int LATEST_BY_NEW = 2;
    public static final int LATEST_BY_NONE = 0;
    public static final String NO_ROWID_MARKER = "*!*";
    public static final int ORDER_DIRECTION_ASCENDING = 0;
    public static final int ORDER_DIRECTION_DESCENDING = 1;
    public static final int SELECT_MODEL_ANALYTIC = 3;
    public static final int SELECT_MODEL_CHOOSE = 1;
    public static final int SELECT_MODEL_CURSOR = 6;
    public static final int SELECT_MODEL_DISTINCT = 5;
    public static final int SELECT_MODEL_GROUP_BY = 4;
    public static final int SELECT_MODEL_NONE = 0;
    public static final int SELECT_MODEL_VIRTUAL = 2;
    public static final int SET_OPERATION_EXCEPT = 2;
    public static final int SET_OPERATION_INTERSECT = 3;
    public static final int SET_OPERATION_UNION = 1;
    public static final int SET_OPERATION_UNION_ALL = 0;
    public static final String SUB_QUERY_ALIAS_PREFIX = "_xQdbA";
    private static final ObjList<String> modelTypeName = new ObjList();
    private final LowerCaseCharSequenceObjHashMap<QueryColumn> aliasToColumnMap = new LowerCaseCharSequenceObjHashMap();
    private final LowerCaseCharSequenceObjHashMap<CharSequence> aliasToColumnNameMap = new LowerCaseCharSequenceObjHashMap();
    private final ObjList<CharSequence> bottomUpColumnNames = new ObjList();
    private final ObjList<QueryColumn> bottomUpColumns = new ObjList();
    private final LowerCaseCharSequenceIntHashMap columnAliasIndexes = new LowerCaseCharSequenceIntHashMap();
    private final LowerCaseCharSequenceObjHashMap<CharSequence> columnNameToAliasMap = new LowerCaseCharSequenceObjHashMap();
    private final IntHashSet dependencies = new IntHashSet();
    private final ObjList<ExpressionNode> expressionModels = new ObjList();
    private final ObjList<ExpressionNode> groupBy = new ObjList();
    private final ObjList<ExpressionNode> joinColumns = new ObjList(4);
    private final ObjList<QueryModel> joinModels = new ObjList();
    private final ObjList<ExpressionNode> latestBy = new ObjList();
    private final LowerCaseCharSequenceIntHashMap modelAliasIndexes = new LowerCaseCharSequenceIntHashMap();
    private final ObjList<ExpressionNode> orderBy = new ObjList();
    private final ObjList<ExpressionNode> orderByAdvice = new ObjList();
    private final IntList orderByDirection = new IntList();
    private final IntList orderByDirectionAdvice = new IntList();
    private final LowerCaseCharSequenceIntHashMap orderHash = new LowerCaseCharSequenceIntHashMap(4, 0.5, -1);
    private final IntList orderedJoinModels1 = new IntList();
    private final IntList orderedJoinModels2 = new IntList();
    private final ObjList<ExpressionNode> parsedWhere = new ObjList();
    private final IntHashSet parsedWhereConstants = new IntHashSet();
    private final ObjList<ExpressionNode> sampleByFill = new ObjList();
    private final ArrayDeque<ExpressionNode> sqlNodeStack = new ArrayDeque();
    private final ObjList<QueryColumn> topDownColumns = new ObjList();
    private final LowerCaseCharSequenceHashSet topDownNameSet = new LowerCaseCharSequenceHashSet();
    private final ObjList<ExpressionNode> updateSetColumns = new ObjList();
    private final ObjList<CharSequence> updateTableColumnNames = new ObjList();
    private final IntList updateTableColumnTypes = new IntList();
    private final LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauseModel = new LowerCaseCharSequenceObjHashMap();
    private ExpressionNode alias;
    private boolean artificialStar;
    private ExpressionNode backupWhereClause;
    private ExpressionNode constWhereClause;
    private JoinContext context;
    private boolean distinct = false;
    private boolean isLimitImplemented;
    private boolean isSelectTranslation = false;
    private boolean isUpdateModel;
    private ExpressionNode joinCriteria;
    private int joinKeywordPosition;
    private int joinType = 1;
    private int latestByType = 0;
    private ExpressionNode limitAdviceHi;
    private ExpressionNode limitAdviceLo;
    private ExpressionNode limitHi;
    private ExpressionNode limitLo;
    private int limitPosition;
    private int modelPosition = 0;
    private int modelType = 1;
    private QueryModel nestedModel;
    private boolean nestedModelIsSubQuery = false;
    private int orderByAdviceMnemonic = 0;
    private int orderByPosition;
    private IntList orderedJoinModels = this.orderedJoinModels2;
    private ExpressionNode outerJoinExpressionClause;
    private ExpressionNode postJoinWhereClause;
    private ExpressionNode sampleBy;
    private ExpressionNode sampleByOffset = null;
    private ExpressionNode sampleByTimezoneName = null;
    private ExpressionNode sampleByUnit;
    private int selectModelType = 0;
    private int setOperationType;
    private int tableId = -1;
    private ExpressionNode tableNameExpr;
    private Function tableNameFunction;
    private long tableVersion = -1L;
    private ExpressionNode timestamp;
    private QueryModel unionModel;
    private QueryModel updateTableModel;
    private TableToken updateTableToken;
    private ExpressionNode whereClause;

    private QueryModel() {
        this.joinModels.add(this);
    }

    public static void backupWhereClause(ObjectPool<ExpressionNode> pool, QueryModel model) {
        QueryModel current = model;
        while (current != null) {
            if (current.unionModel != null) {
                QueryModel.backupWhereClause(pool, current.unionModel);
            }
            if (current.updateTableModel != null) {
                QueryModel.backupWhereClause(pool, current.updateTableModel);
            }
            int n = current.joinModels.size();
            for (int i = 0; i < n; ++i) {
                QueryModel m = current.joinModels.get(i);
                if (m == null || current == m) continue;
                QueryModel.backupWhereClause(pool, m);
            }
            current.backupWhereClause = ExpressionNode.deepClone(pool, current.whereClause);
            current = current.nestedModel;
        }
    }

    public static void restoreWhereClause(ObjectPool<ExpressionNode> pool, QueryModel model) {
        QueryModel current = model;
        while (current != null) {
            if (current.unionModel != null) {
                QueryModel.restoreWhereClause(pool, current.unionModel);
            }
            if (current.updateTableModel != null) {
                QueryModel.restoreWhereClause(pool, current.updateTableModel);
            }
            int n = current.joinModels.size();
            for (int i = 0; i < n; ++i) {
                QueryModel m = current.joinModels.get(i);
                if (m == null || current == m) continue;
                QueryModel.restoreWhereClause(pool, m);
            }
            current.whereClause = ExpressionNode.deepClone(pool, current.backupWhereClause);
            current = current.nestedModel;
        }
    }

    public void addBottomUpColumn(QueryColumn column) throws SqlException {
        this.addBottomUpColumn(0, column, false, null);
    }

    public void addBottomUpColumn(QueryColumn column, boolean allowDuplicates) throws SqlException {
        this.addBottomUpColumn(0, column, allowDuplicates, null);
    }

    public void addBottomUpColumn(int position, QueryColumn column, boolean allowDuplicates) throws SqlException {
        this.addBottomUpColumn(position, column, allowDuplicates, null);
    }

    public void addBottomUpColumn(int position, QueryColumn column, boolean allowDuplicates, CharSequence additionalMessage) throws SqlException {
        if (!allowDuplicates && this.aliasToColumnMap.contains(column.getName())) {
            throw SqlException.duplicateColumn(position, column.getName(), additionalMessage);
        }
        this.bottomUpColumns.add(column);
        this.addField(column);
    }

    public void addDependency(int index) {
        this.dependencies.add(index);
    }

    public void addExpressionModel(ExpressionNode node) {
        assert (node.queryModel != null);
        this.expressionModels.add(node);
    }

    public void addField(QueryColumn column) {
        CharSequence alias = column.getAlias();
        ExpressionNode ast = column.getAst();
        assert (alias != null);
        this.aliasToColumnNameMap.put(alias, ast.token);
        this.columnNameToAliasMap.put(ast.token, alias);
        this.bottomUpColumnNames.add(alias);
        this.aliasToColumnMap.put(alias, column);
        this.columnAliasIndexes.put(alias, this.bottomUpColumnNames.size() - 1);
    }

    public void addGroupBy(ExpressionNode node) {
        this.groupBy.add(node);
    }

    public void addJoinColumn(ExpressionNode node) {
        this.joinColumns.add(node);
    }

    public void addJoinModel(QueryModel model) {
        this.joinModels.add(model);
    }

    public void addLatestBy(ExpressionNode latestBy) {
        this.latestBy.add(latestBy);
    }

    public boolean addModelAliasIndex(ExpressionNode node, int index) {
        return this.modelAliasIndexes.put(node.token, index);
    }

    public void addOrderBy(ExpressionNode node, int direction) {
        this.orderBy.add(node);
        this.orderByDirection.add(direction);
    }

    public void addParsedWhereNode(ExpressionNode node, boolean innerPredicate) {
        node.innerPredicate = innerPredicate;
        this.parsedWhere.add(node);
    }

    public void addSampleByFill(ExpressionNode sampleByFill) {
        this.sampleByFill.add(sampleByFill);
    }

    public void addTopDownColumn(QueryColumn column, CharSequence alias) {
        if (this.topDownNameSet.add(alias)) {
            this.topDownColumns.add(column);
        }
    }

    public void addUpdateTableColumnMetadata(int columnType, String columnName) {
        this.updateTableColumnTypes.add(columnType);
        this.updateTableColumnNames.add(columnName);
    }

    public boolean allowsColumnsChange() {
        for (QueryModel union = this; union != null; union = union.getUnionModel()) {
            if (union.getSetOperationType() == 0 && union.getSelectModelType() != 5) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.bottomUpColumns.clear();
        this.aliasToColumnNameMap.clear();
        this.joinModels.clear();
        this.joinModels.add(this);
        this.clearSampleBy();
        this.orderBy.clear();
        this.orderByDirection.clear();
        this.orderByAdvice.clear();
        this.orderByDirectionAdvice.clear();
        this.orderByPosition = 0;
        this.orderByAdviceMnemonic = 0;
        this.isSelectTranslation = false;
        this.groupBy.clear();
        this.dependencies.clear();
        this.parsedWhere.clear();
        this.whereClause = null;
        this.constWhereClause = null;
        this.nestedModel = null;
        this.tableNameExpr = null;
        this.alias = null;
        this.latestByType = 0;
        this.latestBy.clear();
        this.joinCriteria = null;
        this.joinType = 1;
        this.joinKeywordPosition = 0;
        this.orderedJoinModels1.clear();
        this.orderedJoinModels2.clear();
        this.parsedWhereConstants.clear();
        this.columnAliasIndexes.clear();
        this.modelAliasIndexes.clear();
        this.postJoinWhereClause = null;
        this.outerJoinExpressionClause = null;
        this.context = null;
        this.orderedJoinModels = this.orderedJoinModels2;
        this.limitHi = null;
        this.limitLo = null;
        this.limitAdviceHi = null;
        this.limitAdviceLo = null;
        this.limitPosition = 0;
        this.isLimitImplemented = false;
        this.timestamp = null;
        this.sqlNodeStack.clear();
        this.joinColumns.clear();
        this.withClauseModel.clear();
        this.selectModelType = 0;
        this.columnNameToAliasMap.clear();
        this.tableNameFunction = null;
        this.tableId = -1;
        this.tableVersion = -1L;
        this.bottomUpColumnNames.clear();
        this.expressionModels.clear();
        this.distinct = false;
        this.nestedModelIsSubQuery = false;
        this.unionModel = null;
        this.orderHash.clear();
        this.modelPosition = 0;
        this.topDownColumns.clear();
        this.topDownNameSet.clear();
        this.aliasToColumnMap.clear();
        this.isUpdateModel = false;
        this.modelType = 1;
        this.updateSetColumns.clear();
        this.updateTableColumnTypes.clear();
        this.updateTableColumnNames.clear();
        this.updateTableModel = null;
        this.updateTableToken = null;
        this.setOperationType = 0;
        this.artificialStar = false;
    }

    public void clearColumnMapStructs() {
        this.aliasToColumnNameMap.clear();
        this.bottomUpColumnNames.clear();
        this.aliasToColumnMap.clear();
    }

    public void clearOrderBy() {
        this.orderBy.clear();
        this.orderByDirection.clear();
    }

    public void clearSampleBy() {
        this.sampleBy = null;
        this.sampleByUnit = null;
        this.sampleByFill.clear();
        this.sampleByTimezoneName = null;
        this.sampleByOffset = null;
    }

    public boolean containsJoin() {
        QueryModel current = this;
        do {
            if (current.getJoinModels().size() <= 1) continue;
            return true;
        } while ((current = current.getNestedModel()) != null);
        return false;
    }

    public void copyBottomToTopColumns() {
        this.topDownColumns.clear();
        this.topDownNameSet.clear();
        int n = this.bottomUpColumns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn column = this.bottomUpColumns.getQuick(i);
            this.addTopDownColumn(column, column.getAlias());
        }
    }

    public void copyColumnsFrom(QueryModel other, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<ExpressionNode> expressionNodePool) {
        this.clearColumnMapStructs();
        ObjList aliases = other.aliasToColumnMap.keys();
        int n = aliases.size();
        for (int i = 0; i < n; ++i) {
            CharSequence alias = (CharSequence)aliases.getQuick(i);
            QueryColumn qc = other.aliasToColumnMap.get(alias);
            if (qc.getAst().type != 4) {
                qc = queryColumnPool.next().of(alias, expressionNodePool.next().of(4, alias, 0, qc.getAst().position), qc.isIncludeIntoWildcard());
            }
            this.aliasToColumnMap.put(alias, qc);
        }
        ObjList<CharSequence> columnNames = other.bottomUpColumnNames;
        this.bottomUpColumnNames.addAll(columnNames);
        int n2 = columnNames.size();
        for (int i = 0; i < n2; ++i) {
            CharSequence name = columnNames.getQuick(i);
            this.aliasToColumnNameMap.put(name, name);
        }
    }

    public void copyOrderByAdvice(ObjList<ExpressionNode> orderByAdvice) {
        this.orderByAdvice.clear();
        this.orderByAdvice.addAll(orderByAdvice);
    }

    public void copyOrderByDirectionAdvice(IntList orderByDirection) {
        this.orderByDirectionAdvice.clear();
        this.orderByDirectionAdvice.addAll(orderByDirection);
    }

    public void copyUpdateTableMetadata(QueryModel updateTableModel) {
        this.updateTableModel = updateTableModel;
        this.tableId = updateTableModel.tableId;
        this.tableVersion = updateTableModel.tableVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryModel that = (QueryModel)o;
        if (this.joinModels.size() != that.joinModels.size()) {
            return false;
        }
        int n = this.joinModels.size();
        for (int i = 1; i < n; ++i) {
            if (this.joinModels.getQuick(i).equals(that.joinModels.getQuick(i))) continue;
            return false;
        }
        if (this.sqlNodeStack.size() != that.sqlNodeStack.size()) {
            return false;
        }
        Iterator<ExpressionNode> i1 = this.sqlNodeStack.iterator();
        Iterator<ExpressionNode> i2 = that.sqlNodeStack.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            ExpressionNode n2;
            ExpressionNode n1 = i1.next();
            if (Objects.equals(n1, n2 = i2.next())) continue;
            return false;
        }
        return this.orderByPosition == that.orderByPosition && this.latestByType == that.latestByType && this.tableVersion == that.tableVersion && this.joinType == that.joinType && this.joinKeywordPosition == that.joinKeywordPosition && this.limitPosition == that.limitPosition && this.isLimitImplemented == that.isLimitImplemented && this.isSelectTranslation == that.isSelectTranslation && this.selectModelType == that.selectModelType && this.nestedModelIsSubQuery == that.nestedModelIsSubQuery && this.distinct == that.distinct && this.setOperationType == that.setOperationType && this.modelPosition == that.modelPosition && this.orderByAdviceMnemonic == that.orderByAdviceMnemonic && this.tableId == that.tableId && this.isUpdateModel == that.isUpdateModel && this.modelType == that.modelType && this.artificialStar == that.artificialStar && Objects.equals(this.bottomUpColumns, that.bottomUpColumns) && Objects.equals(this.topDownNameSet, that.topDownNameSet) && Objects.equals(this.topDownColumns, that.topDownColumns) && Objects.equals(this.aliasToColumnNameMap, that.aliasToColumnNameMap) && Objects.equals(this.columnNameToAliasMap, that.columnNameToAliasMap) && Objects.equals(this.aliasToColumnMap, that.aliasToColumnMap) && Objects.equals(this.bottomUpColumnNames, that.bottomUpColumnNames) && Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.groupBy, that.groupBy) && Objects.equals(this.orderByDirection, that.orderByDirection) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.orderedJoinModels1, that.orderedJoinModels1) && Objects.equals(this.orderedJoinModels2, that.orderedJoinModels2) && Objects.equals(this.columnAliasIndexes, that.columnAliasIndexes) && Objects.equals(this.modelAliasIndexes, that.modelAliasIndexes) && Objects.equals(this.expressionModels, that.expressionModels) && Objects.equals(this.parsedWhere, that.parsedWhere) && Objects.equals(this.parsedWhereConstants, that.parsedWhereConstants) && Objects.equals(this.orderHash, that.orderHash) && Objects.equals(this.joinColumns, that.joinColumns) && Objects.equals(this.sampleByFill, that.sampleByFill) && Objects.equals(this.latestBy, that.latestBy) && Objects.equals(this.orderByAdvice, that.orderByAdvice) && Objects.equals(this.orderByDirectionAdvice, that.orderByDirectionAdvice) && Objects.equals(this.withClauseModel, that.withClauseModel) && Objects.equals(this.updateSetColumns, that.updateSetColumns) && Objects.equals(this.updateTableColumnTypes, that.updateTableColumnTypes) && Objects.equals(this.updateTableColumnNames, that.updateTableColumnNames) && Objects.equals(this.sampleByTimezoneName, that.sampleByTimezoneName) && Objects.equals(this.sampleByOffset, that.sampleByOffset) && Objects.equals(this.whereClause, that.whereClause) && Objects.equals(this.backupWhereClause, that.backupWhereClause) && Objects.equals(this.postJoinWhereClause, that.postJoinWhereClause) && Objects.equals(this.outerJoinExpressionClause, that.outerJoinExpressionClause) && Objects.equals(this.constWhereClause, that.constWhereClause) && Objects.equals(this.nestedModel, that.nestedModel) && Objects.equals(this.tableNameExpr, that.tableNameExpr) && Objects.equals(this.tableNameFunction, that.tableNameFunction) && Objects.equals(this.alias, that.alias) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.sampleBy, that.sampleBy) && Objects.equals(this.sampleByUnit, that.sampleByUnit) && Objects.equals(this.context, that.context) && Objects.equals(this.joinCriteria, that.joinCriteria) && Objects.equals(this.orderedJoinModels, that.orderedJoinModels) && Objects.equals(this.limitLo, that.limitLo) && Objects.equals(this.limitHi, that.limitHi) && Objects.equals(this.limitAdviceLo, that.limitAdviceLo) && Objects.equals(this.limitAdviceHi, that.limitAdviceHi) && Objects.equals(this.unionModel, that.unionModel) && Objects.equals(this.updateTableModel, that.updateTableModel) && Objects.equals(this.updateTableToken, that.updateTableToken);
    }

    public QueryColumn findBottomUpColumnByAst(ExpressionNode node) {
        int n = this.bottomUpColumns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = this.bottomUpColumns.getQuick(i);
            if (!ExpressionNode.compareNodesExact(node, qc.getAst())) continue;
            return qc;
        }
        return null;
    }

    public ExpressionNode getAlias() {
        return this.alias;
    }

    public LowerCaseCharSequenceObjHashMap<QueryColumn> getAliasToColumnMap() {
        return this.aliasToColumnMap;
    }

    public LowerCaseCharSequenceObjHashMap<CharSequence> getAliasToColumnNameMap() {
        return this.aliasToColumnNameMap;
    }

    public ObjList<CharSequence> getBottomUpColumnNames() {
        return this.bottomUpColumnNames;
    }

    public ObjList<QueryColumn> getBottomUpColumns() {
        return this.bottomUpColumns;
    }

    public int getColumnAliasIndex(CharSequence alias) {
        return this.columnAliasIndexes.get(alias);
    }

    public LowerCaseCharSequenceObjHashMap<CharSequence> getColumnNameToAliasMap() {
        return this.columnNameToAliasMap;
    }

    public ObjList<QueryColumn> getColumns() {
        return this.topDownColumns.size() > 0 ? this.topDownColumns : this.bottomUpColumns;
    }

    public ExpressionNode getConstWhereClause() {
        return this.constWhereClause;
    }

    public JoinContext getContext() {
        return this.context;
    }

    public IntHashSet getDependencies() {
        return this.dependencies;
    }

    public ObjList<ExpressionNode> getExpressionModels() {
        return this.expressionModels;
    }

    public ObjList<ExpressionNode> getGroupBy() {
        return this.groupBy;
    }

    public ObjList<ExpressionNode> getJoinColumns() {
        return this.joinColumns;
    }

    public ExpressionNode getJoinCriteria() {
        return this.joinCriteria;
    }

    public int getJoinKeywordPosition() {
        return this.joinKeywordPosition;
    }

    public ObjList<QueryModel> getJoinModels() {
        return this.joinModels;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public ObjList<ExpressionNode> getLatestBy() {
        return this.latestBy;
    }

    public int getLatestByType() {
        return this.latestByType;
    }

    public ExpressionNode getLimitAdviceHi() {
        return this.limitAdviceHi;
    }

    public ExpressionNode getLimitAdviceLo() {
        return this.limitAdviceLo;
    }

    public ExpressionNode getLimitHi() {
        return this.limitHi;
    }

    public ExpressionNode getLimitLo() {
        return this.limitLo;
    }

    public int getLimitPosition() {
        return this.limitPosition;
    }

    public int getModelAliasIndex(CharSequence column, int start, int end) {
        int index = this.modelAliasIndexes.keyIndex(column, start, end);
        if (index < 0) {
            return this.modelAliasIndexes.valueAt(index);
        }
        return -1;
    }

    public LowerCaseCharSequenceIntHashMap getModelAliasIndexes() {
        return this.modelAliasIndexes;
    }

    public int getModelPosition() {
        return this.modelPosition;
    }

    @Override
    public int getModelType() {
        return this.modelType;
    }

    public CharSequence getName() {
        if (this.alias != null) {
            return this.alias.token;
        }
        if (this.tableNameExpr != null) {
            return this.tableNameExpr.token;
        }
        return null;
    }

    public QueryModel getNestedModel() {
        return this.nestedModel;
    }

    public ObjList<ExpressionNode> getOrderBy() {
        return this.orderBy;
    }

    public ObjList<ExpressionNode> getOrderByAdvice() {
        return this.orderByAdvice;
    }

    public int getOrderByAdviceMnemonic() {
        return this.orderByAdviceMnemonic;
    }

    public IntList getOrderByDirection() {
        return this.orderByDirection;
    }

    public IntList getOrderByDirectionAdvice() {
        return this.orderByDirectionAdvice;
    }

    public int getOrderByPosition() {
        return this.orderByPosition;
    }

    public LowerCaseCharSequenceIntHashMap getOrderHash() {
        return this.orderHash;
    }

    public IntList getOrderedJoinModels() {
        return this.orderedJoinModels;
    }

    public ExpressionNode getOuterJoinExpressionClause() {
        return this.outerJoinExpressionClause;
    }

    public ObjList<ExpressionNode> getParsedWhere() {
        return this.parsedWhere;
    }

    public ExpressionNode getPostJoinWhereClause() {
        return this.postJoinWhereClause;
    }

    @Override
    public QueryModel getQueryModel() {
        return this;
    }

    public ExpressionNode getSampleBy() {
        return this.sampleBy;
    }

    public ObjList<ExpressionNode> getSampleByFill() {
        return this.sampleByFill;
    }

    public ExpressionNode getSampleByOffset() {
        return this.sampleByOffset;
    }

    public ExpressionNode getSampleByTimezoneName() {
        return this.sampleByTimezoneName;
    }

    public ExpressionNode getSampleByUnit() {
        return this.sampleByUnit;
    }

    public int getSelectModelType() {
        return this.selectModelType;
    }

    public int getSetOperationType() {
        return this.setOperationType;
    }

    public int getTableId() {
        return this.tableId;
    }

    @Override
    public CharSequence getTableName() {
        return this.tableNameExpr != null ? this.tableNameExpr.token : null;
    }

    @Override
    public ExpressionNode getTableNameExpr() {
        return this.tableNameExpr;
    }

    public Function getTableNameFunction() {
        return this.tableNameFunction;
    }

    public long getTableVersion() {
        return this.tableVersion;
    }

    public ExpressionNode getTimestamp() {
        return this.timestamp;
    }

    public ObjList<QueryColumn> getTopDownColumns() {
        return this.topDownColumns;
    }

    public QueryModel getUnionModel() {
        return this.unionModel;
    }

    public ObjList<ExpressionNode> getUpdateExpressions() {
        return this.updateSetColumns;
    }

    public ObjList<CharSequence> getUpdateTableColumnNames() {
        return this.updateTableModel != null ? this.updateTableModel.getUpdateTableColumnNames() : this.updateTableColumnNames;
    }

    public IntList getUpdateTableColumnTypes() {
        return this.updateTableModel != null ? this.updateTableModel.getUpdateTableColumnTypes() : this.updateTableColumnTypes;
    }

    public TableToken getUpdateTableToken() {
        return this.updateTableToken;
    }

    public ExpressionNode getWhereClause() {
        return this.whereClause;
    }

    public LowerCaseCharSequenceObjHashMap<WithClauseModel> getWithClauses() {
        return this.withClauseModel;
    }

    public int hashCode() {
        int hash = super.hashCode();
        int n = this.joinModels.size();
        for (int i = 1; i < n; ++i) {
            hash = 31 * hash + Objects.hash(this.joinModels.getQuick(i));
        }
        for (ExpressionNode node : this.sqlNodeStack) {
            hash = 31 * hash + Objects.hash(node);
        }
        return 31 * hash + Objects.hash(this.bottomUpColumns, this.topDownNameSet, this.topDownColumns, this.aliasToColumnNameMap, this.columnNameToAliasMap, this.aliasToColumnMap, this.bottomUpColumnNames, this.orderBy, this.orderByPosition, this.groupBy, this.orderByDirection, this.dependencies, this.orderedJoinModels1, this.orderedJoinModels2, this.columnAliasIndexes, this.modelAliasIndexes, this.expressionModels, this.parsedWhere, this.parsedWhereConstants, this.orderHash, this.joinColumns, this.sampleByFill, this.latestBy, this.orderByAdvice, this.orderByDirectionAdvice, this.withClauseModel, this.updateSetColumns, this.updateTableColumnTypes, this.updateTableColumnNames, this.sampleByTimezoneName, this.sampleByOffset, this.latestByType, this.whereClause, this.backupWhereClause, this.postJoinWhereClause, this.outerJoinExpressionClause, this.constWhereClause, this.nestedModel, this.tableNameExpr, this.tableVersion, this.tableNameFunction, this.alias, this.timestamp, this.sampleBy, this.sampleByUnit, this.context, this.joinCriteria, this.joinType, this.joinKeywordPosition, this.orderedJoinModels, this.limitLo, this.limitHi, this.limitPosition, this.limitAdviceLo, this.limitAdviceHi, this.isLimitImplemented, this.isSelectTranslation, this.selectModelType, this.nestedModelIsSubQuery, this.distinct, this.unionModel, this.setOperationType, this.modelPosition, this.orderByAdviceMnemonic, this.tableId, this.isUpdateModel, this.modelType, this.updateTableModel, this.updateTableToken, this.artificialStar);
    }

    public boolean isArtificialStar() {
        return this.artificialStar;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isLimitImplemented() {
        return this.isLimitImplemented;
    }

    public boolean isNestedModelIsSubQuery() {
        return this.nestedModelIsSubQuery;
    }

    public boolean isSelectTranslation() {
        return this.isSelectTranslation;
    }

    public boolean isTopDownNameMissing(CharSequence columnName) {
        return this.topDownNameSet.excludes(columnName);
    }

    public boolean isUpdate() {
        return this.isUpdateModel;
    }

    public void moveGroupByFrom(QueryModel model) {
        this.groupBy.addAll(model.groupBy);
        model.groupBy.clear();
    }

    public void moveJoinAliasFrom(QueryModel that) {
        ExpressionNode alias = that.alias;
        if (alias != null && !Chars.startsWith(alias.token, SUB_QUERY_ALIAS_PREFIX)) {
            this.setAlias(alias);
            this.addModelAliasIndex(alias, 0);
        }
    }

    public void moveLimitFrom(QueryModel baseModel) {
        this.limitLo = baseModel.getLimitLo();
        this.limitHi = baseModel.getLimitHi();
        baseModel.setLimit(null, null);
    }

    public void moveSampleByFrom(QueryModel model) {
        this.sampleBy = model.sampleBy;
        this.sampleByUnit = model.sampleByUnit;
        this.sampleByFill.clear();
        this.sampleByFill.addAll(model.sampleByFill);
        this.sampleByTimezoneName = model.sampleByTimezoneName;
        this.sampleByOffset = model.sampleByOffset;
        model.clearSampleBy();
    }

    public IntList nextOrderedJoinModels() {
        IntList ordered = this.orderedJoinModels == this.orderedJoinModels1 ? this.orderedJoinModels2 : this.orderedJoinModels1;
        ordered.clear();
        return ordered;
    }

    public ObjList<ExpressionNode> parseWhereClause() {
        ExpressionNode n = this.getWhereClause();
        this.sqlNodeStack.clear();
        while (!this.sqlNodeStack.isEmpty() || n != null) {
            if (n != null && n.token != null) {
                if (SqlKeywords.isAndKeyword(n.token)) {
                    if (n.rhs != null) {
                        this.sqlNodeStack.push(n.rhs);
                    }
                    n = n.lhs;
                    continue;
                }
                this.addParsedWhereNode(n, false);
                n = null;
                continue;
            }
            n = this.sqlNodeStack.poll();
        }
        return this.getParsedWhere();
    }

    public void removeDependency(int index) {
        this.dependencies.remove(index);
    }

    public void replaceJoinModel(int pos, QueryModel model) {
        this.joinModels.setQuick(pos, model);
    }

    public void setAlias(ExpressionNode alias) {
        this.alias = alias;
    }

    public void setArtificialStar(boolean artificialStar) {
        this.artificialStar = artificialStar;
    }

    public void setConstWhereClause(ExpressionNode constWhereClause) {
        this.constWhereClause = constWhereClause;
    }

    public void setContext(JoinContext context) {
        this.context = context;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setIsUpdate(boolean isUpdate) {
        this.isUpdateModel = isUpdate;
    }

    public void setJoinCriteria(ExpressionNode joinCriteria) {
        this.joinCriteria = joinCriteria;
    }

    public void setJoinKeywordPosition(int position) {
        this.joinKeywordPosition = position;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public void setLatestByType(int latestByType) {
        this.latestByType = latestByType;
    }

    public void setLimit(ExpressionNode lo, ExpressionNode hi) {
        this.limitLo = lo;
        this.limitHi = hi;
    }

    public void setLimitAdvice(ExpressionNode lo, ExpressionNode hi) {
        this.limitAdviceLo = lo;
        this.limitAdviceHi = hi;
    }

    public void setLimitImplemented(boolean limitImplemented) {
        this.isLimitImplemented = limitImplemented;
    }

    public void setLimitPosition(int limitPosition) {
        this.limitPosition = limitPosition;
    }

    public void setModelPosition(int modelPosition) {
        this.modelPosition = modelPosition;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public void setNestedModel(QueryModel nestedModel) {
        this.nestedModel = nestedModel;
    }

    public void setNestedModelIsSubQuery(boolean nestedModelIsSubQuery) {
        this.nestedModelIsSubQuery = nestedModelIsSubQuery;
    }

    public void setOrderByAdviceMnemonic(int orderByAdviceMnemonic) {
        this.orderByAdviceMnemonic = orderByAdviceMnemonic;
    }

    public void setOrderByPosition(int orderByPosition) {
        this.orderByPosition = orderByPosition;
    }

    public void setOrderedJoinModels(IntList that) {
        assert (that == this.orderedJoinModels1 || that == this.orderedJoinModels2);
        this.orderedJoinModels = that;
    }

    public void setOuterJoinExpressionClause(ExpressionNode outerJoinExpressionClause) {
        this.outerJoinExpressionClause = outerJoinExpressionClause;
    }

    public void setPostJoinWhereClause(ExpressionNode postJoinWhereClause) {
        this.postJoinWhereClause = postJoinWhereClause;
    }

    public void setSampleBy(ExpressionNode sampleBy) {
        this.sampleBy = sampleBy;
    }

    public void setSampleBy(ExpressionNode sampleBy, ExpressionNode sampleByUnit) {
        this.sampleBy = sampleBy;
        this.sampleByUnit = sampleByUnit;
    }

    public void setSampleByOffset(ExpressionNode sampleByOffset) {
        this.sampleByOffset = sampleByOffset;
    }

    public void setSampleByTimezoneName(ExpressionNode sampleByTimezoneName) {
        this.sampleByTimezoneName = sampleByTimezoneName;
    }

    public void setSelectModelType(int selectModelType) {
        this.selectModelType = selectModelType;
    }

    public void setSelectTranslation(boolean isSelectTranslation) {
        this.isSelectTranslation = isSelectTranslation;
    }

    public void setSetOperationType(int setOperationType) {
        this.setOperationType = setOperationType;
    }

    public void setTableId(int id) {
        this.tableId = id;
    }

    public void setTableNameExpr(ExpressionNode tableNameExpr) {
        this.tableNameExpr = tableNameExpr;
    }

    public void setTableNameFunction(Function function) {
        this.tableNameFunction = function;
    }

    public void setTableVersion(long tableVersion) {
        this.tableVersion = tableVersion;
    }

    public void setTimestamp(ExpressionNode timestamp) {
        this.timestamp = timestamp;
    }

    public void setUnionModel(QueryModel unionModel) {
        this.unionModel = unionModel;
    }

    public void setUpdateTableToken(TableToken tableName) {
        this.updateTableToken = tableName;
    }

    public void setWhereClause(ExpressionNode whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public void toSink(CharSink sink) {
        if (this.modelType == 1) {
            this.toSink0(sink, false, false);
        } else if (this.modelType == 6) {
            this.updateToSink(sink);
        }
    }

    @Override
    public CharSequence translateAlias(CharSequence column) {
        return this.aliasToColumnNameMap.get(column);
    }

    private static void aliasToSink(CharSequence alias, CharSink sink) {
        boolean quote;
        sink.put(' ');
        boolean bl = quote = Chars.indexOf(alias, ' ') != -1;
        if (quote) {
            sink.put('\'').put(alias).put('\'');
        } else {
            sink.put(alias);
        }
    }

    private String getSelectModelTypeText() {
        return modelTypeName.get(this.selectModelType);
    }

    private void sinkColumns(CharSink sink, ObjList<QueryColumn> columns) {
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.put(", ");
            }
            QueryColumn column = columns.getQuick(i);
            CharSequence name = column.getName();
            CharSequence alias = column.getAlias();
            ExpressionNode ast = column.getAst();
            ast.toSink(sink);
            if (column instanceof AnalyticColumn || name == null) {
                ObjList<ExpressionNode> orderBy;
                if (alias != null) {
                    QueryModel.aliasToSink(alias, sink);
                }
                if (name == null) continue;
                AnalyticColumn ac = (AnalyticColumn)column;
                sink.put(" over (");
                ObjList<ExpressionNode> partitionBy = ac.getPartitionBy();
                if (partitionBy.size() > 0) {
                    sink.put("partition by ");
                    int z = partitionBy.size();
                    for (int k = 0; k < z; ++k) {
                        if (k > 0) {
                            sink.put(", ");
                        }
                        partitionBy.getQuick(k).toSink(sink);
                    }
                }
                if ((orderBy = ac.getOrderBy()).size() > 0) {
                    if (partitionBy.size() > 0) {
                        sink.put(' ');
                    }
                    sink.put("order by ");
                    int z = orderBy.size();
                    for (int k = 0; k < z; ++k) {
                        if (k > 0) {
                            sink.put(", ");
                        }
                        orderBy.getQuick(k).toSink(sink);
                        if (ac.getOrderByDirection().getQuick(k) != 1) continue;
                        sink.put(" desc");
                    }
                }
                sink.put(')');
                continue;
            }
            if (alias == null || ast.type == 4 && ast.token.equals(alias)) continue;
            QueryModel.aliasToSink(alias, sink);
        }
    }

    private void toSink0(CharSink sink, boolean joinSlave, boolean showOrderBy) {
        int i;
        int i2;
        int n;
        boolean hasColumns;
        boolean bl = hasColumns = this.topDownColumns.size() > 0 || this.bottomUpColumns.size() > 0;
        if (hasColumns) {
            sink.put(this.getSelectModelTypeText());
            if (this.topDownColumns.size() > 0) {
                sink.put(' ');
                sink.put('[');
                this.sinkColumns(sink, this.topDownColumns);
                sink.put(']');
            }
            if (this.bottomUpColumns.size() > 0) {
                sink.put(' ');
                this.sinkColumns(sink, this.bottomUpColumns);
            }
            sink.put(" from ");
        }
        if (this.tableNameExpr != null) {
            this.tableNameExpr.toSink(sink);
        } else {
            sink.put('(');
            this.nestedModel.toSink0(sink, false, showOrderBy);
            sink.put(')');
        }
        if (this.alias != null) {
            QueryModel.aliasToSink(this.alias.token, sink);
        }
        if (this.getLatestByType() != 2 && this.timestamp != null) {
            sink.put(" timestamp (");
            this.timestamp.toSink(sink);
            sink.put(')');
        }
        if (this.getLatestByType() == 1 && this.getLatestBy().size() > 0) {
            sink.put(" latest by ");
            n = this.getLatestBy().size();
            for (i2 = 0; i2 < n; ++i2) {
                if (i2 > 0) {
                    sink.put(',');
                }
                this.getLatestBy().getQuick(i2).toSink(sink);
            }
        }
        if (this.orderedJoinModels.size() > 1) {
            n = this.orderedJoinModels.size();
            for (i2 = 0; i2 < n; ++i2) {
                QueryModel model = this.joinModels.getQuick(this.orderedJoinModels.getQuick(i2));
                if (model == this) continue;
                switch (model.getJoinType()) {
                    case 2: {
                        sink.put(" left join ");
                        break;
                    }
                    case 4: {
                        sink.put(" asof join ");
                        break;
                    }
                    case 5: {
                        sink.put(" splice join ");
                        break;
                    }
                    case 3: {
                        sink.put(" cross join ");
                        break;
                    }
                    case 6: {
                        sink.put(" lt join ");
                        break;
                    }
                    default: {
                        sink.put(" join ");
                    }
                }
                if (model.getWhereClause() != null) {
                    sink.put('(');
                    model.toSink0(sink, true, showOrderBy);
                    sink.put(')');
                    if (model.getAlias() != null) {
                        QueryModel.aliasToSink(model.getAlias().token, sink);
                    } else if (model.getTableName() != null) {
                        QueryModel.aliasToSink(model.getTableName(), sink);
                    }
                } else {
                    model.toSink0(sink, true, showOrderBy);
                }
                JoinContext jc = model.getContext();
                if (jc != null && jc.aIndexes.size() > 0) {
                    sink.put(" on ");
                    int z = jc.aIndexes.size();
                    for (int k = 0; k < z; ++k) {
                        if (k > 0) {
                            sink.put(" and ");
                        }
                        jc.aNodes.getQuick(k).toSink(sink);
                        sink.put(" = ");
                        jc.bNodes.getQuick(k).toSink(sink);
                    }
                }
                if (model.getOuterJoinExpressionClause() != null) {
                    sink.put(" outer-join-expression ");
                    model.getOuterJoinExpressionClause().toSink(sink);
                }
                if (model.getPostJoinWhereClause() == null) continue;
                sink.put(" post-join-where ");
                model.getPostJoinWhereClause().toSink(sink);
            }
        }
        if (this.getWhereClause() != null) {
            sink.put(" where ");
            this.whereClause.toSink(sink);
        }
        if (this.constWhereClause != null) {
            sink.put(" const-where ");
            this.constWhereClause.toSink(sink);
        }
        if (!joinSlave && this.postJoinWhereClause != null) {
            sink.put(" post-join-where ");
            this.postJoinWhereClause.toSink(sink);
        }
        if (!joinSlave && this.outerJoinExpressionClause != null) {
            sink.put(" outer-join-expressions ");
            this.outerJoinExpressionClause.toSink(sink);
        }
        if (this.getLatestByType() == 2 && this.getLatestBy().size() > 0) {
            sink.put(" latest on ");
            this.timestamp.toSink(sink);
            sink.put(" partition by ");
            n = this.getLatestBy().size();
            for (i2 = 0; i2 < n; ++i2) {
                if (i2 > 0) {
                    sink.put(',');
                }
                this.getLatestBy().getQuick(i2).toSink(sink);
            }
        }
        if (this.sampleBy != null) {
            sink.put(" sample by ");
            this.sampleBy.toSink(sink);
            int fillCount = this.sampleByFill.size();
            if (fillCount > 0) {
                sink.put(" fill(");
                sink.put(this.sampleByFill.getQuick(0));
                if (fillCount > 1) {
                    for (i = 1; i < fillCount; ++i) {
                        sink.put(',');
                        sink.put(this.sampleByFill.getQuick(i));
                    }
                }
                sink.put(')');
            }
            if (this.sampleByTimezoneName != null || this.sampleByOffset != null) {
                sink.put(" align to calendar");
                if (this.sampleByTimezoneName != null) {
                    sink.put(" time zone ");
                    sink.put(this.sampleByTimezoneName);
                }
                if (this.sampleByOffset != null) {
                    sink.put(" with offset ");
                    sink.put(this.sampleByOffset);
                }
            }
        }
        if (showOrderBy && this.orderBy.size() > 0) {
            sink.put(" order by ");
            n = this.orderBy.size();
            for (i2 = 0; i2 < n; ++i2) {
                if (i2 > 0) {
                    sink.put(", ");
                }
                sink.put(this.orderBy.get(i2));
                if (this.orderByDirection.get(i2) != 1) continue;
                sink.put(" desc");
            }
        } else if (this.orderHash.size() > 0 && this.orderBy.size() > 0) {
            sink.put(" order by ");
            ObjList columnNames = this.orderHash.keys();
            int n2 = columnNames.size();
            for (i = 0; i < n2; ++i) {
                if (i > 0) {
                    sink.put(", ");
                }
                CharSequence key = (CharSequence)columnNames.getQuick(i);
                sink.put(key);
                if (this.orderHash.get(key) != 1) continue;
                sink.put(" desc");
            }
        }
        if (this.getLimitLo() != null || this.getLimitHi() != null) {
            sink.put(" limit ");
            if (this.getLimitLo() != null) {
                this.getLimitLo().toSink(sink);
            }
            if (this.getLimitHi() != null) {
                sink.put(',');
                this.getLimitHi().toSink(sink);
            }
        }
        if (this.unionModel != null) {
            if (this.setOperationType == 3) {
                sink.put(" intersect ");
            } else if (this.setOperationType == 2) {
                sink.put(" except ");
            } else {
                sink.put(" union ");
                if (this.setOperationType == 0) {
                    sink.put("all ");
                }
            }
            this.unionModel.toSink0(sink, false, showOrderBy);
        }
    }

    private void updateToSink(CharSink sink) {
        sink.put("update ");
        this.tableNameExpr.toSink(sink);
        if (this.alias != null) {
            sink.put(" as");
            QueryModel.aliasToSink(this.alias.token, sink);
        }
        sink.put(" set ");
        int n = this.getUpdateExpressions().size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.put(',');
            }
            CharSequence columnExpr = this.getUpdateExpressions().get((int)i).token;
            sink.put(columnExpr);
            sink.put(" = ");
            QueryColumn setColumn = this.getNestedModel().getColumns().getQuick(i);
            setColumn.getAst().toSink(sink);
        }
        if (this.getNestedModel() != null) {
            sink.put(" from (");
            this.getNestedModel().toSink(sink);
            sink.put(")");
        }
    }

    static {
        modelTypeName.extendAndSet(0, "select");
        modelTypeName.extendAndSet(1, "select-choose");
        modelTypeName.extendAndSet(2, "select-virtual");
        modelTypeName.extendAndSet(3, "select-analytic");
        modelTypeName.extendAndSet(4, "select-group-by");
        modelTypeName.extendAndSet(5, "select-distinct");
        modelTypeName.extendAndSet(6, "select-cursor");
    }

    public static final class QueryModelFactory
    implements ObjectFactory<QueryModel> {
        @Override
        public QueryModel newInstance() {
            return new QueryModel();
        }
    }
}

