/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.nio;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferPool
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferPool.class);
    final BlockingQueue<ByteBuffer> bufferPool;
    private static final double ONE_MB = 1048576.0;
    private Calendar lastRateSampleTime = Calendar.getInstance();
    private final Calendar startTime = Calendar.getInstance();
    double lastRateSampleMBps = -1.0;
    double overallMBps = -1.0;
    private long totalBytesExtracted = 0L;
    private long lastTotalBytesExtracted = 0L;
    final double maxRateMBps;

    public BufferPool(int bufferCount, int bufferCapacity, boolean allocateDirect, double maxRateMBps) {
        this.bufferPool = new LinkedBlockingDeque<ByteBuffer>(BufferPool.createBuffers(bufferCount, bufferCapacity, allocateDirect));
        this.maxRateMBps = maxRateMBps;
    }

    public synchronized boolean returnBuffer(ByteBuffer buffer, int bytesProcessed) {
        this.totalBytesExtracted += (long)bytesProcessed;
        buffer.clear();
        return this.bufferPool.add(buffer);
    }

    public synchronized ByteBuffer poll() {
        this.computeRate();
        double weightedAvg = this.lastRateSampleMBps * 0.7 + this.overallMBps * 0.3;
        if (this.overallMBps >= this.maxRateMBps || weightedAvg >= this.maxRateMBps) {
            return null;
        }
        return (ByteBuffer)this.bufferPool.poll();
    }

    public int size() {
        return this.bufferPool.size();
    }

    private synchronized void computeRate() {
        Calendar now = Calendar.getInstance();
        long measurementDurationMillis = now.getTimeInMillis() - this.lastRateSampleTime.getTimeInMillis();
        double durationSecs = (double)measurementDurationMillis / 1000.0;
        if (durationSecs >= 0.75) {
            long totalDurationMillis = now.getTimeInMillis() - this.startTime.getTimeInMillis();
            double totalDurationSecs = (double)totalDurationMillis / 1000.0;
            long differenceBytes = this.totalBytesExtracted - this.lastTotalBytesExtracted;
            this.lastTotalBytesExtracted = this.totalBytesExtracted;
            this.lastRateSampleTime = now;
            double bps = (double)differenceBytes / durationSecs;
            double totalBps = (double)this.totalBytesExtracted / totalDurationSecs;
            this.lastRateSampleMBps = bps / 1048576.0;
            this.overallMBps = totalBps / 1048576.0;
        }
    }

    public static List<ByteBuffer> createBuffers(int bufferCount, int bufferCapacity, boolean allocateDirect) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (int i = 0; i < bufferCount; ++i) {
            ByteBuffer buffer = allocateDirect ? ByteBuffer.allocateDirect(bufferCapacity) : ByteBuffer.allocate(bufferCapacity);
            buffers.add(buffer);
        }
        return buffers;
    }

    private void logChannelReadRates() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Overall rate= %,.4f MB/s / Current Rate= %,.4f MB/s / Total Bytes Read= %d", this.overallMBps, this.lastRateSampleMBps, this.totalBytesExtracted));
        }
    }

    @Override
    public void run() {
        this.computeRate();
        this.logChannelReadRates();
    }
}

