/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.util.Assert;

public final class XorCsrfTokenRequestAttributeHandler
extends CsrfTokenRequestAttributeHandler {
    private SecureRandom secureRandom = new SecureRandom();

    public void setSecureRandom(SecureRandom secureRandom) {
        Assert.notNull((Object)secureRandom, (String)"secureRandom cannot be null");
        this.secureRandom = secureRandom;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, Supplier<CsrfToken> deferredCsrfToken) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        Assert.notNull(deferredCsrfToken, (String)"deferredCsrfToken cannot be null");
        Supplier<CsrfToken> updatedCsrfToken = this.deferCsrfTokenUpdate(deferredCsrfToken);
        super.handle(request, response, updatedCsrfToken);
    }

    private Supplier<CsrfToken> deferCsrfTokenUpdate(Supplier<CsrfToken> csrfTokenSupplier) {
        return new CachedCsrfTokenSupplier(() -> {
            CsrfToken csrfToken = (CsrfToken)csrfTokenSupplier.get();
            Assert.state((csrfToken != null ? 1 : 0) != 0, (String)"csrfToken supplier returned null");
            String updatedToken = XorCsrfTokenRequestAttributeHandler.createXoredCsrfToken(this.secureRandom, csrfToken.getToken());
            return new DefaultCsrfToken(csrfToken.getHeaderName(), csrfToken.getParameterName(), updatedToken);
        });
    }

    @Override
    public String resolveCsrfTokenValue(HttpServletRequest request, CsrfToken csrfToken) {
        String actualToken = super.resolveCsrfTokenValue(request, csrfToken);
        return XorCsrfTokenRequestAttributeHandler.getTokenValue(actualToken, csrfToken.getToken());
    }

    private static String getTokenValue(String actualToken, String token) {
        byte[] actualBytes;
        try {
            actualBytes = Base64.getUrlDecoder().decode(actualToken);
        }
        catch (Exception ex) {
            return null;
        }
        byte[] tokenBytes = Utf8.encode((CharSequence)token);
        int tokenSize = tokenBytes.length;
        if (actualBytes.length != tokenSize * 2) {
            return null;
        }
        byte[] xoredCsrf = new byte[tokenSize];
        byte[] randomBytes = new byte[tokenSize];
        System.arraycopy(actualBytes, 0, randomBytes, 0, tokenSize);
        System.arraycopy(actualBytes, tokenSize, xoredCsrf, 0, tokenSize);
        byte[] csrfBytes = XorCsrfTokenRequestAttributeHandler.xorCsrf(randomBytes, xoredCsrf);
        return Utf8.decode((byte[])csrfBytes);
    }

    private static String createXoredCsrfToken(SecureRandom secureRandom, String token) {
        byte[] tokenBytes = Utf8.encode((CharSequence)token);
        byte[] randomBytes = new byte[tokenBytes.length];
        secureRandom.nextBytes(randomBytes);
        byte[] xoredBytes = XorCsrfTokenRequestAttributeHandler.xorCsrf(randomBytes, tokenBytes);
        byte[] combinedBytes = new byte[tokenBytes.length + randomBytes.length];
        System.arraycopy(randomBytes, 0, combinedBytes, 0, randomBytes.length);
        System.arraycopy(xoredBytes, 0, combinedBytes, randomBytes.length, xoredBytes.length);
        return Base64.getUrlEncoder().encodeToString(combinedBytes);
    }

    private static byte[] xorCsrf(byte[] randomBytes, byte[] csrfBytes) {
        Assert.isTrue((randomBytes.length == csrfBytes.length ? 1 : 0) != 0, (String)"arrays must be equal length");
        int len = csrfBytes.length;
        byte[] xoredCsrf = new byte[len];
        System.arraycopy(csrfBytes, 0, xoredCsrf, 0, len);
        for (int i = 0; i < len; ++i) {
            int n = i;
            xoredCsrf[n] = (byte)(xoredCsrf[n] ^ randomBytes[i]);
        }
        return xoredCsrf;
    }

    private static final class CachedCsrfTokenSupplier
    implements Supplier<CsrfToken> {
        private final Supplier<CsrfToken> delegate;
        private CsrfToken csrfToken;

        private CachedCsrfTokenSupplier(Supplier<CsrfToken> delegate) {
            this.delegate = delegate;
        }

        @Override
        public CsrfToken get() {
            if (this.csrfToken == null) {
                this.csrfToken = this.delegate.get();
            }
            return this.csrfToken;
        }
    }
}

