/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.mvstore.rtree;

import java.util.Arrays;

public class SpatialKey {
    private final long id;
    private final float[] minMax;

    public SpatialKey(long l, float ... fArray) {
        this.id = l;
        this.minMax = fArray;
    }

    public SpatialKey(long l, SpatialKey spatialKey) {
        this.id = l;
        this.minMax = (float[])spatialKey.minMax.clone();
    }

    public float min(int n) {
        return this.minMax[n + n];
    }

    public void setMin(int n, float f) {
        this.minMax[n + n] = f;
    }

    public float max(int n) {
        return this.minMax[n + n + 1];
    }

    public void setMax(int n, float f) {
        this.minMax[n + n + 1] = f;
    }

    public long getId() {
        return this.id;
    }

    public boolean isNull() {
        return this.minMax.length == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id).append(": (");
        for (int i = 0; i < this.minMax.length; i += 2) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.minMax[i]).append('/').append(this.minMax[i + 1]);
        }
        return stringBuilder.append(")").toString();
    }

    public int hashCode() {
        return (int)(this.id >>> 32 ^ this.id);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SpatialKey)) {
            return false;
        }
        SpatialKey spatialKey = (SpatialKey)object;
        if (this.id != spatialKey.id) {
            return false;
        }
        return this.equalsIgnoringId(spatialKey);
    }

    public boolean equalsIgnoringId(SpatialKey spatialKey) {
        return Arrays.equals(this.minMax, spatialKey.minMax);
    }
}

