/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.DataCorruptionException;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageImmutable;
import jetbrains.exodus.tree.btree.BottomPage;
import jetbrains.exodus.tree.btree.InternalPage;
import org.jetbrains.annotations.NotNull;

public class BTree
extends BTreeBase {
    private final RandomAccessLoggable rootLoggable;
    private final BasePageImmutable root;

    public BTree(@NotNull Log log, long rootAddress, boolean allowsDuplicates, int structureId) {
        this(log, BTreeBalancePolicy.DEFAULT, rootAddress, allowsDuplicates, structureId);
    }

    public BTree(@NotNull Log log, @NotNull BTreeBalancePolicy policy, long rootAddress, boolean allowsDuplicates, int structureId) {
        super(log, policy, allowsDuplicates, structureId);
        if (rootAddress == -1L) {
            throw new IllegalArgumentException("Can't instantiate not empty tree with null root address.");
        }
        this.rootLoggable = this.getLoggable(rootAddress);
        byte type = this.rootLoggable.getType();
        if (type != 2 && type != 3) {
            throw new ExodusException("Unexpected root page type: " + type);
        }
        ByteIterableWithAddress data = this.rootLoggable.getData();
        ByteIteratorWithAddress it = data.iterator();
        this.size = CompressedUnsignedLongByteIterable.getLong(it);
        this.root = this.loadRootPage(data.clone((int)(it.getAddress() - data.getDataAddress())));
    }

    @Override
    public long getRootAddress() {
        return this.rootLoggable.getAddress();
    }

    @Override
    @NotNull
    public BTreeMutable getMutableCopy() {
        BTreeMutable result = new BTreeMutable(this);
        result.addExpiredLoggable(this.rootLoggable);
        return result;
    }

    @Override
    @NotNull
    protected BasePage getRoot() {
        return this.root;
    }

    @NotNull
    private BasePageImmutable loadRootPage(@NotNull ByteIterableWithAddress data) {
        BasePageImmutable result;
        byte type = this.rootLoggable.getType();
        switch (type) {
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                result = new BottomPage(this, data);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                result = new InternalPage(this, data);
                break;
            }
            default: {
                DataCorruptionException.raise("Unexpected loggable type: " + type, this.log, this.rootLoggable.getAddress());
                throw new RuntimeException();
            }
        }
        return result;
    }
}

