/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

public abstract class ClusteringStrategy {
    public static final ClusteringStrategy LINEAR = new LinearClusteringStrategy();
    public static final ClusteringStrategy QUADRATIC = new QuadraticClusteringStrategy();
    public static final ClusteringStrategy EXPONENTIAL = new ExponentialClusteringStrategy();
    private int maxClusterSize = Integer.MAX_VALUE;

    public abstract int getFirstClusterSize();

    abstract int getNextClusterSize(int var1);

    public void setMaxClusterSize(int maxClusterSize) {
        this.maxClusterSize = maxClusterSize;
    }

    public int getMaxClusterSize() {
        return this.maxClusterSize;
    }

    public boolean isLinear() {
        return false;
    }

    protected int adjustClusterSize(int nextClusterSize) {
        return Math.min(nextClusterSize, this.maxClusterSize);
    }

    public static class ExponentialClusteringStrategy
    extends DefaultInitialClusteringStrategy {
        public ExponentialClusteringStrategy() {
        }

        public ExponentialClusteringStrategy(int firstClusterSize) {
            super(firstClusterSize);
        }

        @Override
        int getNextClusterSize(int prevClusterSize) {
            return this.adjustClusterSize((prevClusterSize << 3) / 5);
        }
    }

    public static class QuadraticClusteringStrategy
    extends DefaultInitialClusteringStrategy {
        public QuadraticClusteringStrategy() {
        }

        public QuadraticClusteringStrategy(int firstClusterSize) {
            super(firstClusterSize);
        }

        @Override
        int getNextClusterSize(int prevClusterSize) {
            return this.adjustClusterSize(prevClusterSize + this.firstClusterSize);
        }
    }

    public static class LinearClusteringStrategy
    extends DefaultInitialClusteringStrategy {
        public LinearClusteringStrategy() {
        }

        public LinearClusteringStrategy(int firstClusterSize) {
            super(firstClusterSize);
        }

        @Override
        int getNextClusterSize(int prevClusterSize) {
            return prevClusterSize;
        }

        @Override
        public boolean isLinear() {
            return true;
        }
    }

    private static abstract class DefaultInitialClusteringStrategy
    extends ClusteringStrategy {
        private static final int DEFAULT_FIRST_CLUSTER_SIZE = 4096;
        protected final int firstClusterSize;

        protected DefaultInitialClusteringStrategy() {
            this(4096);
        }

        protected DefaultInitialClusteringStrategy(int firstClusterSize) {
            this.firstClusterSize = firstClusterSize;
        }

        @Override
        public int getFirstClusterSize() {
            return this.firstClusterSize;
        }
    }
}

