/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.ClusterConverter;
import jetbrains.exodus.vfs.ClusterIterator;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.FileExistsException;
import jetbrains.exodus.vfs.IOCancellingPolicyProvider;
import jetbrains.exodus.vfs.VfsAppendingStream;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.exodus.vfs.VfsInputStream;
import jetbrains.exodus.vfs.VfsOutputStream;
import jetbrains.exodus.vfs.VfsSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileSystem {
    private static final String SETTINGS_STORE_NAME = "jetbrains.exodus.vfs.settings";
    private static final String PATHNAMES_STORE_NAME = "jetbrains.exodus.vfs.pathnames";
    private static final String CONTENTS_STORE_NAME = "jetbrains.exodus.vfs.contents";
    private final Environment env;
    private final VfsConfig config;
    private final VfsSettings settings;
    private final Store pathnames;
    private final Store contents;
    private final AtomicLong fileDescriptorSequence;
    @Nullable
    private IOCancellingPolicyProvider cancellingPolicyProvider;
    @Nullable
    private ClusterConverter clusterConverter;

    public VirtualFileSystem(@NotNull Environment env) {
        this(env, VfsConfig.DEFAULT);
    }

    public VirtualFileSystem(@NotNull Environment env, @NotNull VfsConfig config) {
        this(env, config, StoreConfig.WITHOUT_DUPLICATES);
    }

    public VirtualFileSystem(@NotNull Environment env, @NotNull VfsConfig config, @Nullable Transaction txn) {
        this(env, config, StoreConfig.WITHOUT_DUPLICATES, txn);
    }

    public VirtualFileSystem(@NotNull Environment env, @NotNull VfsConfig config, @NotNull StoreConfig contentsStoreConfig) {
        this(env, config, contentsStoreConfig, null);
    }

    public VirtualFileSystem(@NotNull Environment env, @NotNull VfsConfig config, @NotNull StoreConfig contentsStoreConfig, @Nullable Transaction txn) {
        this.env = env;
        this.config = config;
        if (txn != null) {
            this.settings = new VfsSettings(env, env.openStore(SETTINGS_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn));
            this.pathnames = env.openStore(PATHNAMES_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn);
            this.contents = env.openStore(CONTENTS_STORE_NAME, contentsStoreConfig, txn);
        } else {
            this.settings = (VfsSettings)env.computeInTransaction(txn13 -> new VfsSettings(env, env.openStore(SETTINGS_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn13)));
            this.pathnames = (Store)env.computeInTransaction(txn12 -> env.openStore(PATHNAMES_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn12));
            this.contents = (Store)env.computeInTransaction(txn1 -> env.openStore(CONTENTS_STORE_NAME, contentsStoreConfig, txn1));
        }
        this.fileDescriptorSequence = new AtomicLong();
        ByteIterable bi = this.settings.get(txn, "jetbrains.exodus.vfs.settings.nextFreePathId");
        if (bi != null) {
            this.fileDescriptorSequence.set(LongBinding.compressedEntryToLong((ByteIterable)bi));
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    @NotNull
    public File createFile(@NotNull Transaction txn, @NotNull String path) {
        return this.doCreateFile(txn, this.fileDescriptorSequence.getAndIncrement(), path);
    }

    @NotNull
    public File createFile(@NotNull Transaction txn, long fileDescriptor, @NotNull String path) {
        long next;
        long current;
        while (!this.fileDescriptorSequence.compareAndSet(current = this.fileDescriptorSequence.get(), next = Math.max(fileDescriptor + 1L, current))) {
        }
        return this.doCreateFile(txn, fileDescriptor, path);
    }

    public File createUniqueFile(@NotNull Transaction txn, @NotNull String pathPrefix) {
        while (true) {
            try {
                return this.createFile(txn, pathPrefix + new Object().hashCode());
            }
            catch (FileExistsException fileExistsException) {
                continue;
            }
            break;
        }
    }

    @Nullable
    public File openFile(@NotNull Transaction txn, @NotNull String path, boolean create) {
        ArrayByteIterable key = StringBinding.stringToEntry((String)path);
        ByteIterable value = this.pathnames.get(txn, (ByteIterable)key);
        if (value != null) {
            return new File(path, value);
        }
        if (create) {
            return this.createFile(txn, path);
        }
        return null;
    }

    public boolean renameFile(@NotNull Transaction txn, @NotNull File origin, @NotNull String newPath) {
        ArrayByteIterable key = StringBinding.stringToEntry((String)newPath);
        ByteIterable value = this.pathnames.get(txn, (ByteIterable)key);
        if (value != null) {
            return false;
        }
        File newFile = new File(newPath, origin.getDescriptor(), origin.getCreated(), System.currentTimeMillis());
        this.pathnames.put(txn, (ByteIterable)key, (ByteIterable)newFile.toByteIterable());
        this.pathnames.delete(txn, (ByteIterable)StringBinding.stringToEntry((String)origin.getPath()));
        return true;
    }

    @Nullable
    public File deleteFile(@NotNull Transaction txn, @NotNull String path) {
        ByteIterable fileMetadata;
        ArrayByteIterable key = StringBinding.stringToEntry((String)path);
        try (Cursor cursor = this.pathnames.openCursor(txn);){
            fileMetadata = cursor.getSearchKey((ByteIterable)key);
            if (fileMetadata != null) {
                cursor.deleteCurrent();
            }
        }
        if (fileMetadata != null) {
            File result = new File(path, fileMetadata);
            try (ClusterIterator iterator = new ClusterIterator(this, txn, result);){
                while (iterator.hasCluster()) {
                    iterator.deleteCurrent();
                    iterator.moveToNext();
                }
            }
            return result;
        }
        return null;
    }

    public long getNumberOfFiles(@NotNull Transaction txn) {
        return this.pathnames.count(txn);
    }

    @NotNull
    public Iterable<File> getFiles(final @NotNull Transaction txn) {
        try (final Cursor cursor = this.pathnames.openCursor(txn);){
            Iterable<File> iterable = () -> new Iterator<File>(){

                @Override
                public boolean hasNext() {
                    return cursor.getNext();
                }

                @Override
                public File next() {
                    return new File(StringBinding.entryToString((ByteIterable)cursor.getKey()), cursor.getValue());
                }

                @Override
                public void remove() {
                    VirtualFileSystem.this.deleteFile(txn, StringBinding.entryToString((ByteIterable)cursor.getKey()));
                }
            };
            return iterable;
        }
    }

    public long getFileLength(@NotNull Transaction txn, @NotNull File file) {
        return this.getFileLength(txn, file.getDescriptor());
    }

    public long getFileLength(@NotNull Transaction txn, long fileDescriptor) {
        Object cachedLength;
        if (txn.isReadonly() && (cachedLength = txn.getUserObject((Object)("vfs.file.length." + fileDescriptor))) instanceof Long) {
            return (Long)cachedLength;
        }
        try (ClusterIterator it = new ClusterIterator(this, txn, fileDescriptor, -1L);){
            long result = it.size();
            if (txn.isReadonly()) {
                txn.setUserObject((Object)("vfs.file.length." + fileDescriptor), (Object)result);
            }
            long l = result;
            return l;
        }
    }

    public long diskUsage(@NotNull Transaction txn) {
        long result = 0L;
        for (File file : this.getFiles(txn)) {
            result += this.getFileLength(txn, file);
        }
        return result;
    }

    public VfsInputStream readFile(@NotNull Transaction txn, @NotNull File file) {
        return new VfsInputStream(this, txn, file.getDescriptor());
    }

    public VfsInputStream readFile(@NotNull Transaction txn, long fileDescriptor) {
        return new VfsInputStream(this, txn, fileDescriptor);
    }

    @NotNull
    public VfsInputStream readFile(@NotNull Transaction txn, @NotNull File file, long fromPosition) {
        return new VfsInputStream(this, txn, file.getDescriptor(), fromPosition);
    }

    public void touchFile(@NotNull Transaction txn, @NotNull File file) {
        new LastModifiedTrigger(txn, file, this.pathnames).run();
    }

    public OutputStream writeFile(@NotNull Transaction txn, @NotNull File file) {
        return new VfsOutputStream(this, txn, file.getDescriptor(), new LastModifiedTrigger(txn, file, this.pathnames));
    }

    public OutputStream writeFile(@NotNull Transaction txn, @NotNull File file, long fromPosition) {
        return new VfsOutputStream(this, txn, file.getDescriptor(), fromPosition, new LastModifiedTrigger(txn, file, this.pathnames));
    }

    public OutputStream writeFile(@NotNull Transaction txn, long fileDescriptor) {
        return new VfsOutputStream(this, txn, fileDescriptor, null);
    }

    public OutputStream writeFile(@NotNull Transaction txn, long fileDescriptor, long fromPosition) {
        return new VfsOutputStream(this, txn, fileDescriptor, fromPosition, null);
    }

    public OutputStream appendFile(@NotNull Transaction txn, @NotNull File file) {
        return new VfsAppendingStream(this, txn, file, new LastModifiedTrigger(txn, file, this.pathnames));
    }

    public void shutdown() {
        this.saveFileDescriptorSequence(null);
    }

    public VfsConfig getConfig() {
        return this.config;
    }

    @Nullable
    public IOCancellingPolicyProvider getCancellingPolicyProvider() {
        return this.cancellingPolicyProvider;
    }

    public void setCancellingPolicyProvider(@NotNull IOCancellingPolicyProvider cancellingPolicyProvider) {
        this.cancellingPolicyProvider = cancellingPolicyProvider;
    }

    @Nullable
    public ClusterConverter getClusterConverter() {
        return this.clusterConverter;
    }

    public void setClusterConverter(@Nullable ClusterConverter clusterConverter) {
        this.clusterConverter = clusterConverter;
    }

    public void dump(@NotNull Transaction txn, @NotNull Path directory) throws IOException {
        for (File file : this.getFiles(txn)) {
            VfsInputStream content = this.readFile(txn, file);
            Throwable throwable = null;
            try {
                Files.copy(content, Paths.get(directory.toString(), file.getPath()), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (content == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)content).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)content).close();
            }
        }
    }

    Store getContents() {
        return this.contents;
    }

    private File doCreateFile(@NotNull Transaction txn, long fileDescriptor, @NotNull String path) {
        ArrayByteIterable key = StringBinding.stringToEntry((String)(path = String.format(path, fileDescriptor)));
        ByteIterable value = this.pathnames.get(txn, (ByteIterable)key);
        if (value != null) {
            throw new FileExistsException(path);
        }
        long currentTime = System.currentTimeMillis();
        File result = new File(path, fileDescriptor, currentTime, currentTime);
        this.pathnames.put(txn, (ByteIterable)key, (ByteIterable)result.toByteIterable());
        this.saveFileDescriptorSequence(txn);
        return result;
    }

    private void saveFileDescriptorSequence(@Nullable Transaction txn) {
        this.settings.put(txn, "jetbrains.exodus.vfs.settings.nextFreePathId", (ByteIterable)LongBinding.longToCompressedEntry((long)this.fileDescriptorSequence.get()));
    }

    private static class LastModifiedTrigger
    implements Runnable {
        private final File file;
        private final Transaction txn;
        private final Store pathnames;

        private LastModifiedTrigger(@NotNull Transaction txn, @NotNull File file, @NotNull Store pathnames) {
            this.file = file;
            this.txn = txn;
            this.pathnames = pathnames;
        }

        @Override
        public void run() {
            File modified = new File(this.file);
            ArrayByteIterable key = StringBinding.stringToEntry((String)modified.getPath());
            this.pathnames.put(this.txn, (ByteIterable)key, (ByteIterable)modified.toByteIterable());
        }
    }
}

