/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.repository.encryption.AesGcmByteArrayRepositoryEncryptor;
import org.apache.nifi.repository.encryption.RepositoryEncryptor;
import org.apache.nifi.repository.encryption.configuration.EncryptedRepositoryType;
import org.apache.nifi.repository.encryption.configuration.EncryptionMetadataHeader;
import org.apache.nifi.repository.encryption.configuration.kms.StandardRepositoryKeyProviderFactory;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.NiFiProperties;
import org.wali.SerDe;
import org.wali.UpdateType;

public class EncryptedSchemaRepositoryRecordSerde
implements SerDe<SerializedRepositoryRecord> {
    private final SerDe<SerializedRepositoryRecord> wrappedSerDe;
    private final RepositoryEncryptor<byte[], byte[]> encryptor;
    private final String keyId;

    public EncryptedSchemaRepositoryRecordSerde(SerDe<SerializedRepositoryRecord> wrappedSerDe, NiFiProperties niFiProperties) {
        this.wrappedSerDe = Objects.requireNonNull(wrappedSerDe, "Wrapped SerDe required");
        StandardRepositoryKeyProviderFactory repositoryKeyProviderFactory = new StandardRepositoryKeyProviderFactory();
        KeyProvider keyProvider = repositoryKeyProviderFactory.getKeyProvider(EncryptedRepositoryType.FLOWFILE, niFiProperties);
        this.encryptor = new AesGcmByteArrayRepositoryEncryptor(keyProvider, EncryptionMetadataHeader.FLOWFILE);
        this.keyId = niFiProperties.getFlowFileRepoEncryptionKeyId();
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        this.wrappedSerDe.writeHeader(out);
    }

    public void readHeader(DataInputStream in) throws IOException {
        this.wrappedSerDe.readHeader(in);
    }

    @Deprecated
    public void serializeEdit(SerializedRepositoryRecord previousRecordState, SerializedRepositoryRecord newRecordState, DataOutputStream out) throws IOException {
        this.serializeRecord(newRecordState, out);
    }

    public void serializeRecord(SerializedRepositoryRecord record, DataOutputStream out) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream tempDataStream = new DataOutputStream(byteArrayOutputStream);
        String recordId = this.getRecordIdentifier(record).toString();
        this.wrappedSerDe.serializeRecord((Object)record, tempDataStream);
        tempDataStream.flush();
        byte[] plainSerializedBytes = byteArrayOutputStream.toByteArray();
        this.encryptToStream(plainSerializedBytes, recordId, out);
    }

    private void encryptToStream(byte[] plainSerializedBytes, String recordId, DataOutputStream out) throws IOException {
        byte[] cipherBytes = (byte[])this.encryptor.encrypt((Object)plainSerializedBytes, recordId, this.keyId);
        out.writeInt(cipherBytes.length);
        out.write(cipherBytes);
    }

    @Deprecated
    public SerializedRepositoryRecord deserializeEdit(DataInputStream in, Map<Object, SerializedRepositoryRecord> currentRecordStates, int version) throws IOException {
        return this.deserializeRecord(in, version);
    }

    public SerializedRepositoryRecord deserializeRecord(DataInputStream in, int version) throws IOException {
        int encryptedRecordLength = in.readInt();
        if (encryptedRecordLength == -1) {
            return null;
        }
        byte[] cipherBytes = new byte[encryptedRecordLength];
        StreamUtils.fillBuffer((InputStream)in, (byte[])cipherBytes);
        DataInputStream wrappedInputStream = this.decryptToStream(cipherBytes);
        return (SerializedRepositoryRecord)this.wrappedSerDe.deserializeRecord(wrappedInputStream, version);
    }

    private DataInputStream decryptToStream(byte[] cipherBytes) {
        byte[] plainSerializedBytes = (byte[])this.encryptor.decrypt((Object)cipherBytes, "[pending record ID]");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(plainSerializedBytes);
        return new DataInputStream(byteArrayInputStream);
    }

    public Object getRecordIdentifier(SerializedRepositoryRecord record) {
        return this.wrappedSerDe.getRecordIdentifier((Object)record);
    }

    public UpdateType getUpdateType(SerializedRepositoryRecord record) {
        return this.wrappedSerDe.getUpdateType((Object)record);
    }

    public String getLocation(SerializedRepositoryRecord record) {
        return this.wrappedSerDe.getLocation((Object)record);
    }

    public int getVersion() {
        return this.wrappedSerDe.getVersion();
    }
}

