/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.std.Chars;
import io.questdb.std.DirectLongList;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.O3PartitionPurgeTask;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

public class O3PartitionPurgeJob
extends AbstractQueueConsumerJob<O3PartitionPurgeTask>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(O3PartitionPurgeJob.class);
    private final CairoConfiguration configuration;
    private final StringSink[] fileNameSinks;
    private final AtomicBoolean halted = new AtomicBoolean(false);
    private final ObjList<DirectLongList> partitionList;
    private final ObjList<TxReader> txnReaders;
    private final ObjList<TxnScoreboard> txnScoreboards;

    public O3PartitionPurgeJob(MessageBus messageBus, int workerCount) {
        super(messageBus.getO3PurgeDiscoveryQueue(), messageBus.getO3PurgeDiscoverySubSeq());
        this.configuration = messageBus.getConfiguration();
        this.fileNameSinks = new StringSink[workerCount];
        this.partitionList = new ObjList(workerCount);
        this.txnScoreboards = new ObjList(workerCount);
        this.txnReaders = new ObjList(workerCount);
        for (int i = 0; i < workerCount; ++i) {
            this.fileNameSinks[i] = new StringSink();
            this.partitionList.add(new DirectLongList((long)this.configuration.getPartitionPurgeListCapacity() * 2L, 3));
            this.txnScoreboards.add(new TxnScoreboard(this.configuration.getFilesFacade(), this.configuration.getTxnScoreboardEntryCount()));
            this.txnReaders.add(new TxReader(this.configuration.getFilesFacade()));
        }
    }

    @Override
    public void close() {
        if (this.halted.compareAndSet(false, true)) {
            Misc.freeObjList(this.partitionList);
            Misc.freeObjList(this.txnReaders);
            Misc.freeObjList(this.txnScoreboards);
        }
    }

    private static void parsePartitionDateVersion(StringSink fileNameSink, DirectLongList partitionList, CharSequence tableName, DateFormat partitionByFormat) {
        int index = Chars.lastIndexOf(fileNameSink, '.');
        int len = fileNameSink.length();
        if (index < 0) {
            index = len;
        }
        try {
            if (index < len) {
                long partitionVersion = Numbers.parseLong(fileNameSink, index + 1, len);
                partitionList.add(partitionVersion + 1L);
            } else {
                partitionList.add(0L);
            }
            try {
                long partitionTs = partitionByFormat.parse(fileNameSink, 0, index, null);
                partitionList.add(partitionTs);
            }
            catch (NumericException e) {
                LOG.error().$("unknown directory [table=").utf8(tableName).$(", dir=").utf8(fileNameSink).I$();
                partitionList.setPos(partitionList.size() - 1L);
            }
        }
        catch (NumericException e) {
            LOG.error().$("unknown directory [table=").utf8(tableName).$(", dir=").utf8(fileNameSink).I$();
        }
    }

    private static void processDetachedPartition(FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        long lastTxn = txReader.getTxn();
        int n = lo - 1;
        for (int i = hi - 2; i > n; i -= 2) {
            long nameTxn = partitionList.get(i);
            boolean rangeUnlocked = nameTxn < lastTxn && txnScoreboard.isRangeAvailable(nameTxn, lastTxn);
            path.trimTo(tableRootLen);
            TableUtils.setPathForPartition(path, partitionBy, partitionTimestamp, false);
            TableUtils.txnPartitionConditionally(path, nameTxn - 1L);
            path.$();
            if (!rangeUnlocked) {
                LOG.info().$("cannot purge partition directory, locked for reading [path=").utf8(path).I$();
                break;
            }
            LOG.info().$("purging dropped partition directory [path=").utf8(path).I$();
            ff.unlinkOrRemove(path, LOG);
            lastTxn = nameTxn;
        }
    }

    private static void processPartition(FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        boolean partitionInTxnFile;
        boolean bl = partitionInTxnFile = txReader.getPartitionSizeByPartitionTimestamp(partitionTimestamp) > 0L;
        if (partitionInTxnFile) {
            O3PartitionPurgeJob.processPartition0(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, hi);
        } else {
            O3PartitionPurgeJob.processDetachedPartition(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, hi);
        }
    }

    private static void processPartition0(FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        long lastCommittedPartitionName = txReader.getPartitionNameTxnByPartitionTimestamp(partitionTimestamp);
        if (lastCommittedPartitionName > -1L) {
            assert ((long)hi <= partitionList.size());
            for (int i = lo + 2; i < hi; i += 2) {
                long nextNameVersion = Math.min(lastCommittedPartitionName + 1L, partitionList.get(i));
                long previousNameVersion = partitionList.get(i - 2);
                boolean rangeUnlocked = previousNameVersion < nextNameVersion && txnScoreboard.isRangeAvailable(previousNameVersion, nextNameVersion);
                path.trimTo(tableRootLen);
                TableUtils.setPathForPartition(path, partitionBy, partitionTimestamp, false);
                TableUtils.txnPartitionConditionally(path, previousNameVersion - 1L);
                path.$();
                if (rangeUnlocked) {
                    LOG.info().$("purging overwritten partition directory [path=").utf8(path).I$();
                    ff.unlinkOrRemove(path, LOG);
                    continue;
                }
                LOG.info().$("cannot purge overwritten partition directory, locked for reading [path=").utf8(path).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverPartitions(FilesFacade ff, StringSink fileNameSink, DirectLongList partitionList, CharSequence root, TableToken tableToken, TxnScoreboard txnScoreboard, TxReader txReader, int partitionBy) {
        LOG.info().$("processing [table=").utf8(tableToken.getDirName()).I$();
        Path path = Path.getThreadLocal(root).concat(tableToken);
        int plimit = path.length();
        partitionList.clear();
        DateFormat partitionByFormat = PartitionBy.getPartitionDirFormatMethod(partitionBy);
        long p = ff.findFirst(path.$());
        if (p > 0L) {
            try {
                do {
                    if (!ff.isDirOrSoftLinkDirNoDots(path, plimit, ff.findName(p), ff.findType(p), fileNameSink)) continue;
                    O3PartitionPurgeJob.parsePartitionDateVersion(fileNameSink, partitionList, tableToken.getDirName(), partitionByFormat);
                    path.trimTo(plimit).$();
                } while (ff.findNext(p) > 0);
            }
            finally {
                ff.findClose(p);
            }
        }
        assert (partitionList.size() % 2L == 0L);
        Vect.sort128BitAscInPlace(partitionList.getAddress(), partitionList.size() / 2L);
        long partitionTimestamp = Long.MIN_VALUE;
        int lo = 0;
        int n = (int)partitionList.size();
        path.of(root).concat(tableToken);
        int tableRootLen = path.length();
        try {
            txnScoreboard.ofRO(path);
            txReader.ofRO(path.trimTo(tableRootLen).concat("_txn").$(), partitionBy);
            TableUtils.safeReadTxn(txReader, this.configuration.getMillisecondClock(), this.configuration.getSpinLockTimeout());
            for (int i = 0; i < n; i += 2) {
                long currentPartitionTs = partitionList.get(i + 1);
                if (currentPartitionTs == partitionTimestamp) continue;
                if (i > lo + 2 || i > 0 && txReader.getPartitionSizeByPartitionTimestamp(partitionTimestamp) < 0L) {
                    O3PartitionPurgeJob.processPartition(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, i);
                }
                lo = i;
                partitionTimestamp = currentPartitionTs;
            }
            if (n > lo + 2 || txReader.getPartitionSizeByPartitionTimestamp(partitionTimestamp) < 0L) {
                O3PartitionPurgeJob.processPartition(ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, n);
            }
        }
        catch (CairoException ex) {
            LOG.error().$("could not purge partition open [table=`").utf8(tableToken.getDirName()).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            LOG.error().$(ex.getFlyweightMessage()).$();
        }
        finally {
            txReader.clear();
            txnScoreboard.clear();
        }
        LOG.info().$("processed [table=").$(tableToken).I$();
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        O3PartitionPurgeTask task = (O3PartitionPurgeTask)this.queue.get(cursor);
        this.discoverPartitions(this.configuration.getFilesFacade(), this.fileNameSinks[workerId], this.partitionList.get(workerId), this.configuration.getRoot(), task.getTableToken(), this.txnScoreboards.get(workerId), this.txnReaders.get(workerId), task.getPartitionBy());
        this.subSeq.done(cursor);
        return true;
    }
}

