/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.Nullable;

public class CastBooleanToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Tk)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            return SymbolConstant.newInstance(arg.getSymbol(null));
        }
        return new Func(arg);
    }

    private static class Func
    extends SymbolFunction
    implements UnaryFunction {
        private final Function arg;

        public Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            return this.arg.getInt(rec);
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            return this.arg.getSymbol(rec);
        }

        @Override
        public CharSequence getSymbolB(Record rec) {
            return this.arg.getSymbolB(rec);
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        @Nullable
        public SymbolTable newSymbolTable() {
            return this;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val("::symbol");
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return symbolKey == 1 ? "true" : "false";
        }
    }
}

