/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.ImmutableIterator;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ObjObjHashMap<K, V>
implements Iterable<Entry<K, V>>,
Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final Object noEntryValue = new Object();
    private final EntryIterator iterator = new EntryIterator();
    private final double loadFactor;
    private int capacity;
    private int free;
    private K[] keys;
    private int mask;
    private V[] values;

    public ObjObjHashMap() {
        this(8);
    }

    public ObjObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private ObjObjHashMap(int initialCapacity, double loadFactor) {
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        this.capacity = Math.max(initialCapacity, 16);
        this.loadFactor = loadFactor;
        this.keys = new Object[Numbers.ceilPow2((int)((double)this.capacity / loadFactor))];
        this.values = new Object[this.keys.length];
        this.mask = this.keys.length - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, noEntryValue);
    }

    public V get(K key) {
        return this.valueAt(this.keyIndex(key));
    }

    @Override
    @NotNull
    public Iterator<Entry<K, V>> iterator() {
        this.iterator.index = 0;
        return this.iterator;
    }

    public int keyIndex(K key) {
        int index = Hash.spread(key.hashCode()) & this.mask;
        K kv = this.keys[index];
        if (kv == noEntryValue) {
            return index;
        }
        if (kv == key || key.equals(kv)) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public void put(K key, V value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public void putAt(int index, K key, V value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return;
        }
        this.putAt0(index, key, value);
    }

    public boolean putIfAbsent(K key, V value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt(index, key, value);
            return true;
        }
        return false;
    }

    public int size() {
        return this.capacity - this.free;
    }

    public V valueAt(int index) {
        int index1 = -index - 1;
        return index < 0 ? (V)this.values[index1] : null;
    }

    private int probe(K key, int index) {
        K kv;
        do {
            if ((kv = this.keys[index = index + 1 & this.mask]) != noEntryValue) continue;
            return index;
        } while (kv != key && !key.equals(kv));
        return -index - 1;
    }

    private void putAt0(int index, K key, V value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        this.free = this.capacity *= 2;
        V[] oldValues = this.values;
        K[] oldKeys = this.keys;
        this.keys = new Object[Numbers.ceilPow2(Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor)))];
        this.values = new Object[this.keys.length];
        Arrays.fill(this.keys, noEntryValue);
        this.mask = this.keys.length - 1;
        int i = oldKeys.length;
        while (i-- > 0) {
            if (oldKeys[i] == noEntryValue) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    public class EntryIterator
    implements ImmutableIterator<Entry<K, V>> {
        private final Entry<K, V> entry = new Entry();
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ObjObjHashMap.this.values.length && (ObjObjHashMap.this.keys[this.index] != noEntryValue || this.scan());
        }

        @Override
        public Entry<K, V> next() {
            this.entry.key = ObjObjHashMap.this.keys[this.index];
            int index1 = this.index++;
            this.entry.value = ObjObjHashMap.this.values[index1];
            return this.entry;
        }

        private boolean scan() {
            do {
                ++this.index;
            } while (this.index < ObjObjHashMap.this.values.length && ObjObjHashMap.this.keys[this.index] == noEntryValue);
            return this.index < ObjObjHashMap.this.values.length;
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;
    }
}

