/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect;

import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingDirectoryUtils {
    protected static final String NAR_UNPACKED_SUFFIX = "nar-unpacked";
    protected static final String HASH_FILENAME = "nar-digest";
    private static final Logger logger = LoggerFactory.getLogger(WorkingDirectoryUtils.class);

    public static void reconcileWorkingDirectory(File workingDirectory) {
        WorkingDirectoryUtils.purgeIncompleteUnpackedNars(new File(new File(workingDirectory, "nar"), "extensions"));
        WorkingDirectoryUtils.purgeIncompleteUnpackedNars(new File(workingDirectory, "extensions"));
    }

    public static void purgeIncompleteUnpackedNars(File directory) {
        File[] unpackedDirs = directory.listFiles(file -> file.isDirectory() && file.getName().endsWith(NAR_UNPACKED_SUFFIX));
        if (unpackedDirs == null || unpackedDirs.length == 0) {
            logger.debug("Found no unpacked NARs in {}", (Object)directory);
            if (logger.isDebugEnabled()) {
                logger.debug("Directory contains: {}", (Object)Arrays.deepToString(directory.listFiles()));
            }
            return;
        }
        for (File unpackedDir : unpackedDirs) {
            File narHashFile = new File(unpackedDir, HASH_FILENAME);
            if (narHashFile.exists()) {
                logger.debug("Already successfully unpacked {}", (Object)unpackedDir);
                continue;
            }
            WorkingDirectoryUtils.purgeDirectory(unpackedDir);
        }
    }

    public static void purgeDirectory(File directory) {
        if (directory.exists()) {
            WorkingDirectoryUtils.deleteRecursively(directory);
            logger.debug("Cleaned up {}", (Object)directory);
        }
    }

    private static void deleteRecursively(File fileOrDirectory) {
        File[] files;
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File file : files) {
                WorkingDirectoryUtils.deleteRecursively(file);
            }
        }
        WorkingDirectoryUtils.deleteQuietly(fileOrDirectory);
    }

    private static void deleteQuietly(File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            logger.debug("Failed to cleanup temporary file {}", (Object)file);
        }
    }
}

