/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.registry.security.authorization.AuthorizationAuditor;
import org.apache.nifi.registry.security.authorization.AuthorizationRequest;
import org.apache.nifi.registry.security.authorization.AuthorizationResult;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.Resource;
import org.apache.nifi.registry.security.authorization.UserContextKeys;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;

public interface Authorizable {
    public Authorizable getParentAuthorizable();

    public Resource getResource();

    default public Resource getRequestedResource() {
        return this.getResource();
    }

    default public boolean isAuthorized(Authorizer authorizer, RequestAction action, NiFiUser user) {
        return AuthorizationResult.Result.Approved.equals((Object)this.checkAuthorization(authorizer, action, user).getResult());
    }

    default public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        HashMap<String, String> userContext;
        if (user == null) {
            return AuthorizationResult.denied((String)"Unknown user.");
        }
        if (user.getClientAddress() != null && !user.getClientAddress().trim().isEmpty()) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        final Resource resource = this.getResource();
        final Resource requestedResource = this.getRequestedResource();
        AuthorizationRequest request = new AuthorizationRequest.Builder().identity(user.getIdentity()).groups(user.getGroups()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(false)).action(action).resource(resource).requestedResource(requestedResource).resourceContext(resourceContext).userContext(userContext).explanationSupplier(() -> {
            StringBuilder safeDescription = new StringBuilder("Unable to ");
            if (RequestAction.READ.equals((Object)action)) {
                safeDescription.append("view ");
            } else {
                safeDescription.append("modify ");
            }
            safeDescription.append(resource.getSafeDescription()).append(".");
            return safeDescription.toString();
        }).build();
        AuthorizationResult result = authorizer.authorize(request);
        if (AuthorizationResult.Result.ResourceNotFound.equals((Object)result.getResult())) {
            final Authorizable parent = this.getParentAuthorizable();
            if (parent == null) {
                return AuthorizationResult.denied((String)"No applicable policies could be found.");
            }
            Authorizable parentProxy = new Authorizable(){

                @Override
                public Authorizable getParentAuthorizable() {
                    return parent.getParentAuthorizable();
                }

                @Override
                public Resource getRequestedResource() {
                    return requestedResource;
                }

                @Override
                public Resource getResource() {
                    final Resource parentResource = parent.getResource();
                    return new Resource(){

                        public String getIdentifier() {
                            return parentResource.getIdentifier();
                        }

                        public String getName() {
                            return parentResource.getName();
                        }

                        public String getSafeDescription() {
                            return resource.getSafeDescription();
                        }
                    };
                }
            };
            return parentProxy.checkAuthorization(authorizer, action, user, resourceContext);
        }
        return result;
    }

    default public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user) {
        return this.checkAuthorization(authorizer, action, user, null);
    }

    default public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        HashMap<String, String> userContext;
        if (user == null) {
            throw new AccessDeniedException("Unknown user.");
        }
        if (user.getClientAddress() != null && !user.getClientAddress().trim().isEmpty()) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        final Resource resource = this.getResource();
        final Resource requestedResource = this.getRequestedResource();
        AuthorizationRequest request = new AuthorizationRequest.Builder().identity(user.getIdentity()).groups(user.getGroups()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(true)).action(action).resource(resource).requestedResource(requestedResource).resourceContext(resourceContext).userContext(userContext).explanationSupplier(() -> {
            StringBuilder safeDescription = new StringBuilder("Unable to ");
            if (RequestAction.READ.equals((Object)action)) {
                safeDescription.append("view ");
            } else {
                safeDescription.append("modify ");
            }
            safeDescription.append(resource.getSafeDescription()).append(".");
            return safeDescription.toString();
        }).build();
        AuthorizationResult result = authorizer.authorize(request);
        if (AuthorizationResult.Result.ResourceNotFound.equals((Object)result.getResult())) {
            final Authorizable parent = this.getParentAuthorizable();
            if (parent == null) {
                AuthorizationResult failure = AuthorizationResult.denied((String)"No applicable policies could be found.");
                if (authorizer instanceof AuthorizationAuditor) {
                    ((AuthorizationAuditor)authorizer).auditAccessAttempt(request, failure);
                }
                throw new AccessDeniedException(failure.getExplanation());
            }
            Authorizable parentProxy = new Authorizable(){

                @Override
                public Authorizable getParentAuthorizable() {
                    return parent.getParentAuthorizable();
                }

                @Override
                public Resource getRequestedResource() {
                    return requestedResource;
                }

                @Override
                public Resource getResource() {
                    final Resource parentResource = parent.getResource();
                    return new Resource(){

                        public String getIdentifier() {
                            return parentResource.getIdentifier();
                        }

                        public String getName() {
                            return parentResource.getName();
                        }

                        public String getSafeDescription() {
                            return resource.getSafeDescription();
                        }
                    };
                }
            };
            parentProxy.authorize(authorizer, action, user, resourceContext);
        } else if (AuthorizationResult.Result.Denied.equals((Object)result.getResult())) {
            throw new AccessDeniedException(result.getExplanation());
        }
    }

    default public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user) throws AccessDeniedException {
        this.authorize(authorizer, action, user, null);
    }
}

