/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.identity.IdentityMapper;

public final class UserGroupProviderUtils {
    public static final String PROP_INITIAL_USER_IDENTITY_PREFIX = "Initial User Identity ";
    public static final Pattern INITIAL_USER_IDENTITY_PATTERN = Pattern.compile("Initial User Identity \\S+");

    public static Set<String> getInitialUserIdentities(AuthorizerConfigurationContext configurationContext, IdentityMapper identityMapper) {
        HashSet<String> initialUserIdentities = new HashSet<String>();
        for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
            Matcher matcher = INITIAL_USER_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            initialUserIdentities.add(identityMapper.mapUser((String)entry.getValue()));
        }
        return initialUserIdentities;
    }

    private UserGroupProviderUtils() {
    }
}

