/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service.mapper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.extension.TagCount;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.extension.manifest.Restriction;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntityType;
import org.apache.nifi.registry.db.entity.BundleEntity;
import org.apache.nifi.registry.db.entity.BundleVersionDependencyEntity;
import org.apache.nifi.registry.db.entity.BundleVersionEntity;
import org.apache.nifi.registry.db.entity.ExtensionEntity;
import org.apache.nifi.registry.db.entity.ExtensionProvidedServiceApiEntity;
import org.apache.nifi.registry.db.entity.ExtensionRestrictionEntity;
import org.apache.nifi.registry.db.entity.TagCountEntity;
import org.apache.nifi.registry.extension.bundle.BuildInfo;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleInfo;
import org.apache.nifi.registry.extension.bundle.BundleVersionDependency;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.serialization.SerializationException;
import org.apache.nifi.registry.serialization.Serializer;

public class ExtensionMappings {
    public static BundleEntity map(Bundle bundle) {
        BundleEntity entity = new BundleEntity();
        entity.setId(bundle.getIdentifier());
        entity.setName(bundle.getName());
        entity.setDescription(bundle.getDescription());
        entity.setCreated(new Date(bundle.getCreatedTimestamp()));
        entity.setModified(new Date(bundle.getModifiedTimestamp()));
        entity.setType(BucketItemEntityType.BUNDLE);
        entity.setBucketId(bundle.getBucketIdentifier());
        entity.setGroupId(bundle.getGroupId());
        entity.setArtifactId(bundle.getArtifactId());
        entity.setBundleType(bundle.getBundleType());
        return entity;
    }

    public static Bundle map(BucketEntity bucketEntity, BundleEntity bundleEntity) {
        Bundle bundle = new Bundle();
        bundle.setIdentifier(bundleEntity.getId());
        bundle.setName(bundleEntity.getName());
        bundle.setDescription(bundleEntity.getDescription());
        bundle.setCreatedTimestamp(bundleEntity.getCreated().getTime());
        bundle.setModifiedTimestamp(bundleEntity.getModified().getTime());
        bundle.setBucketIdentifier(bundleEntity.getBucketId());
        if (bucketEntity != null) {
            bundle.setBucketName(bucketEntity.getName());
        } else {
            bundle.setBucketName(bundleEntity.getBucketName());
        }
        bundle.setGroupId(bundleEntity.getGroupId());
        bundle.setArtifactId(bundleEntity.getArtifactId());
        bundle.setBundleType(bundleEntity.getBundleType());
        bundle.setVersionCount(bundleEntity.getVersionCount());
        return bundle;
    }

    public static BundleVersionEntity map(BundleVersionMetadata bundleVersionMetadata) {
        BundleVersionEntity entity = new BundleVersionEntity();
        entity.setId(bundleVersionMetadata.getId());
        entity.setBundleId(bundleVersionMetadata.getBundleId());
        entity.setBucketId(bundleVersionMetadata.getBucketId());
        entity.setVersion(bundleVersionMetadata.getVersion());
        entity.setCreated(new Date(bundleVersionMetadata.getTimestamp()));
        entity.setCreatedBy(bundleVersionMetadata.getAuthor());
        entity.setDescription(bundleVersionMetadata.getDescription());
        entity.setSha256Hex(bundleVersionMetadata.getSha256());
        entity.setSha256Supplied(bundleVersionMetadata.getSha256Supplied());
        entity.setContentSize(bundleVersionMetadata.getContentSize());
        entity.setSystemApiVersion(bundleVersionMetadata.getSystemApiVersion());
        BuildInfo buildInfo = bundleVersionMetadata.getBuildInfo();
        entity.setBuildTool(buildInfo.getBuildTool());
        entity.setBuildFlags(buildInfo.getBuildFlags());
        entity.setBuildBranch(buildInfo.getBuildBranch());
        entity.setBuildTag(buildInfo.getBuildTag());
        entity.setBuildRevision(buildInfo.getBuildRevision());
        entity.setBuiltBy(buildInfo.getBuiltBy());
        entity.setBuilt(new Date(buildInfo.getBuilt()));
        return entity;
    }

    public static BundleVersionMetadata map(BundleVersionEntity bundleVersionEntity) {
        BundleVersionMetadata bundleVersionMetadata = new BundleVersionMetadata();
        bundleVersionMetadata.setId(bundleVersionEntity.getId());
        bundleVersionMetadata.setBundleId(bundleVersionEntity.getBundleId());
        bundleVersionMetadata.setBucketId(bundleVersionEntity.getBucketId());
        bundleVersionMetadata.setGroupId(bundleVersionEntity.getGroupId());
        bundleVersionMetadata.setArtifactId(bundleVersionEntity.getArtifactId());
        bundleVersionMetadata.setVersion(bundleVersionEntity.getVersion());
        bundleVersionMetadata.setTimestamp(bundleVersionEntity.getCreated().getTime());
        bundleVersionMetadata.setAuthor(bundleVersionEntity.getCreatedBy());
        bundleVersionMetadata.setDescription(bundleVersionEntity.getDescription());
        bundleVersionMetadata.setSha256(bundleVersionEntity.getSha256Hex());
        bundleVersionMetadata.setSha256Supplied(Boolean.valueOf(bundleVersionEntity.getSha256Supplied()));
        bundleVersionMetadata.setContentSize(bundleVersionEntity.getContentSize());
        bundleVersionMetadata.setSystemApiVersion(bundleVersionEntity.getSystemApiVersion());
        BuildInfo buildInfo = new BuildInfo();
        buildInfo.setBuildTool(bundleVersionEntity.getBuildTool());
        buildInfo.setBuildFlags(bundleVersionEntity.getBuildFlags());
        buildInfo.setBuildBranch(bundleVersionEntity.getBuildBranch());
        buildInfo.setBuildTag(bundleVersionEntity.getBuildTag());
        buildInfo.setBuildRevision(bundleVersionEntity.getBuildRevision());
        buildInfo.setBuiltBy(bundleVersionEntity.getBuiltBy());
        buildInfo.setBuilt(bundleVersionEntity.getBuilt().getTime());
        bundleVersionMetadata.setBuildInfo(buildInfo);
        return bundleVersionMetadata;
    }

    public static BundleVersionDependencyEntity map(BundleVersionDependency bundleVersionDependency) {
        BundleVersionDependencyEntity entity = new BundleVersionDependencyEntity();
        entity.setGroupId(bundleVersionDependency.getGroupId());
        entity.setArtifactId(bundleVersionDependency.getArtifactId());
        entity.setVersion(bundleVersionDependency.getVersion());
        return entity;
    }

    public static BundleVersionDependency map(BundleVersionDependencyEntity dependencyEntity) {
        BundleVersionDependency dependency = new BundleVersionDependency();
        dependency.setGroupId(dependencyEntity.getGroupId());
        dependency.setArtifactId(dependencyEntity.getArtifactId());
        dependency.setVersion(dependencyEntity.getVersion());
        return dependency;
    }

    public static ExtensionEntity map(Extension extension, Serializer<Extension> extensionSerializer) {
        int index;
        String extensionContent;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            extensionSerializer.serialize(extension, out);
            extensionContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to serialize extension", e);
        }
        ExtensionEntity entity = new ExtensionEntity();
        entity.setName(extension.getName());
        String fullName = entity.getName();
        if (fullName != null && (index = fullName.lastIndexOf(46)) > 0 && index < fullName.length() - 1) {
            entity.setDisplayName(fullName.substring(index + 1));
        }
        if (StringUtils.isBlank((CharSequence)entity.getDisplayName())) {
            entity.setDisplayName(extension.getName());
        }
        entity.setExtensionType(extension.getType());
        entity.setContent(extensionContent);
        if (extension.getTags() != null) {
            entity.setTags(extension.getTags().stream().collect(Collectors.toSet()));
        }
        if (extension.getProvidedServiceAPIs() != null) {
            entity.setProvidedServiceApis(extension.getProvidedServiceAPIs().stream().map(p -> ExtensionMappings.map(p)).collect(Collectors.toSet()));
        } else {
            entity.setProvidedServiceApis(Collections.emptySet());
        }
        if (extension.getRestricted() != null && extension.getRestricted().getRestrictions() != null) {
            entity.setRestrictions(extension.getRestricted().getRestrictions().stream().map(r -> ExtensionMappings.map(r)).collect(Collectors.toSet()));
        } else {
            entity.setRestrictions(Collections.emptySet());
        }
        return entity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Extension map(ExtensionEntity entity, Serializer<Extension> extensionSerializer) {
        byte[] content = entity.getContent().getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream input = new ByteArrayInputStream(content);){
            Extension extension = extensionSerializer.deserialize(input);
            return extension;
        }
        catch (IOException e) {
            throw new SerializationException("Unable to deserialize extension", e);
        }
    }

    public static ExtensionMetadata mapToMetadata(ExtensionEntity entity, Serializer<Extension> extensionSerializer) {
        Extension extension = ExtensionMappings.map(entity, extensionSerializer);
        BundleInfo bundleInfo = new BundleInfo();
        bundleInfo.setBucketId(entity.getBucketId());
        bundleInfo.setBucketName(entity.getBucketName());
        bundleInfo.setBundleId(entity.getBundleId());
        bundleInfo.setGroupId(entity.getGroupId());
        bundleInfo.setArtifactId(entity.getArtifactId());
        bundleInfo.setVersion(entity.getVersion());
        bundleInfo.setBundleType(entity.getBundleType());
        bundleInfo.setSystemApiVersion(entity.getSystemApiVersion());
        ExtensionMetadata metadata = new ExtensionMetadata();
        metadata.setName(extension.getName());
        metadata.setDisplayName(entity.getDisplayName());
        metadata.setType(extension.getType());
        metadata.setDescription(extension.getDescription());
        metadata.setDeprecationNotice(extension.getDeprecationNotice());
        metadata.setRestricted(extension.getRestricted());
        metadata.setProvidedServiceAPIs(extension.getProvidedServiceAPIs());
        metadata.setTags(extension.getTags());
        metadata.setBundleInfo(bundleInfo);
        metadata.setHasAdditionalDetails(entity.getHasAdditionalDetails());
        return metadata;
    }

    public static ExtensionProvidedServiceApiEntity map(ProvidedServiceAPI providedServiceApi) {
        ExtensionProvidedServiceApiEntity entity = new ExtensionProvidedServiceApiEntity();
        entity.setClassName(providedServiceApi.getClassName());
        entity.setGroupId(providedServiceApi.getGroupId());
        entity.setArtifactId(providedServiceApi.getArtifactId());
        entity.setVersion(providedServiceApi.getVersion());
        return entity;
    }

    public static ProvidedServiceAPI map(ExtensionProvidedServiceApiEntity entity) {
        ProvidedServiceAPI providedServiceApi = new ProvidedServiceAPI();
        providedServiceApi.setClassName(entity.getClassName());
        providedServiceApi.setGroupId(entity.getGroupId());
        providedServiceApi.setArtifactId(entity.getArtifactId());
        providedServiceApi.setVersion(entity.getVersion());
        return providedServiceApi;
    }

    public static ExtensionRestrictionEntity map(Restriction restriction) {
        ExtensionRestrictionEntity restrictionEntity = new ExtensionRestrictionEntity();
        restrictionEntity.setRequiredPermission(restriction.getRequiredPermission());
        restrictionEntity.setExplanation(restriction.getExplanation());
        return restrictionEntity;
    }

    public static Restriction map(ExtensionRestrictionEntity restrictionEntity) {
        Restriction restriction = new Restriction();
        restriction.setRequiredPermission(restrictionEntity.getRequiredPermission());
        restriction.setExplanation(restrictionEntity.getExplanation());
        return restriction;
    }

    public static TagCount map(TagCountEntity entity) {
        TagCount tagCount = new TagCount();
        tagCount.setTag(entity.getTag());
        tagCount.setCount(entity.getCount());
        return tagCount;
    }
}

