/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Any;
import io.grpc.Context;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.BootstrapperImpl;
import io.grpc.xds.ControlPlaneClient;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Locality;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsListenerResource;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsResourceType;
import io.grpc.xds.XdsRouteConfigureResource;
import io.grpc.xds.XdsTransportFactory;
import io.grpc.xds.internal.security.TlsContextManagerImpl;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class XdsClientImpl
extends XdsClient
implements XdsClient.XdsResponseHandler,
XdsClient.ResourceStore,
XdsClient.TimerLaunch {
    private static boolean LOG_XDS_NODE_ID = Boolean.parseBoolean(System.getenv("GRPC_LOG_XDS_NODE_ID"));
    private static final Logger classLogger = Logger.getLogger(XdsClientImpl.class.getName());
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "Uncaught exception in XdsClient SynchronizationContext. Panic!", e);
            throw new AssertionError((Object)e);
        }
    });
    private final Map<Bootstrapper.ServerInfo, ControlPlaneClient> serverChannelMap = new HashMap<Bootstrapper.ServerInfo, ControlPlaneClient>();
    private final Map<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>> resourceSubscribers = new HashMap<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>>();
    private final Map<String, XdsResourceType<?>> subscribedResourceTypeUrls = new HashMap();
    private final Map<Bootstrapper.ServerInfo, LoadStatsManager2> loadStatsManagerMap = new HashMap<Bootstrapper.ServerInfo, LoadStatsManager2>();
    private final Map<Bootstrapper.ServerInfo, LoadReportClient> serverLrsClientMap = new HashMap<Bootstrapper.ServerInfo, LoadReportClient>();
    private final XdsTransportFactory xdsTransportFactory;
    private final Bootstrapper.BootstrapInfo bootstrapInfo;
    private final Context context;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final TimeProvider timeProvider;
    private final TlsContextManager tlsContextManager;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private volatile boolean isShutdown;

    XdsClientImpl(XdsTransportFactory xdsTransportFactory, Bootstrapper.BootstrapInfo bootstrapInfo, Context context, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, TimeProvider timeProvider) {
        this.xdsTransportFactory = xdsTransportFactory;
        this.bootstrapInfo = bootstrapInfo;
        this.context = context;
        this.timeService = timeService;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.stopwatchSupplier = stopwatchSupplier;
        this.timeProvider = timeProvider;
        this.tlsContextManager = new TlsContextManagerImpl(bootstrapInfo);
        this.logId = InternalLogId.allocate((String)"xds-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
        if (LOG_XDS_NODE_ID) {
            classLogger.log(Level.INFO, "xDS node ID: {0}", bootstrapInfo.node().getId());
        }
    }

    private void maybeCreateXdsChannelWithLrs(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.serverChannelMap.containsKey(serverInfo)) {
            return;
        }
        XdsTransportFactory.XdsTransport xdsTransport = this.xdsTransportFactory.create(serverInfo);
        ControlPlaneClient xdsChannel = new ControlPlaneClient(xdsTransport, serverInfo, this.bootstrapInfo.node(), this, this, this.context, this.timeService, this.syncContext, this.backoffPolicyProvider, this.stopwatchSupplier, this);
        LoadStatsManager2 loadStatsManager = new LoadStatsManager2(this.stopwatchSupplier);
        this.loadStatsManagerMap.put(serverInfo, loadStatsManager);
        LoadReportClient lrsClient = new LoadReportClient(loadStatsManager, xdsTransport, this.context, this.bootstrapInfo.node(), this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        this.serverChannelMap.put(serverInfo, xdsChannel);
        this.serverLrsClientMap.put(serverInfo, lrsClient);
    }

    @Override
    public void handleResourceResponse(XdsResourceType<?> xdsResourceType, Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce, XdsClient.ProcessingTracker processingTracker) {
        Preconditions.checkNotNull(xdsResourceType, (Object)"xdsResourceType");
        this.syncContext.throwIfNotInThisSynchronizationContext();
        Set<String> toParseResourceNames = null;
        if (xdsResourceType != XdsListenerResource.getInstance() && xdsResourceType != XdsRouteConfigureResource.getInstance() && this.resourceSubscribers.containsKey(xdsResourceType)) {
            toParseResourceNames = this.resourceSubscribers.get(xdsResourceType).keySet();
        }
        XdsResourceType.Args args = new XdsResourceType.Args(serverInfo, versionInfo, nonce, this.bootstrapInfo, this.tlsContextManager, toParseResourceNames);
        this.handleResourceUpdate(args, resources, xdsResourceType, processingTracker);
    }

    @Override
    public void handleStreamClosed(Status error) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cleanUpResourceTimers();
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                if (subscriber.hasResult()) continue;
                subscriber.onError(error, null);
            }
        }
    }

    @Override
    public void handleStreamRestarted(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                if (!((ResourceSubscriber)subscriber).serverInfo.equals(serverInfo)) continue;
                subscriber.restartTimer();
            }
        }
    }

    @Override
    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (XdsClientImpl.this.isShutdown) {
                    return;
                }
                XdsClientImpl.this.isShutdown = true;
                for (ControlPlaneClient xdsChannel : XdsClientImpl.this.serverChannelMap.values()) {
                    xdsChannel.shutdown();
                }
                for (LoadReportClient lrsClient : XdsClientImpl.this.serverLrsClientMap.values()) {
                    lrsClient.stopLoadReporting();
                }
                XdsClientImpl.this.cleanUpResourceTimers();
            }
        });
    }

    @Override
    boolean isShutDown() {
        return this.isShutdown;
    }

    @Override
    public Map<String, XdsResourceType<?>> getSubscribedResourceTypesWithTypeUrl() {
        return Collections.unmodifiableMap(this.subscribedResourceTypeUrls);
    }

    @Override
    @Nullable
    public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo serverInfo, XdsResourceType<? extends XdsClient.ResourceUpdate> type) {
        Map resources = this.resourceSubscribers.getOrDefault(type, Collections.emptyMap());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String key : resources.keySet()) {
            if (!((ResourceSubscriber)resources.get(key)).serverInfo.equals(serverInfo)) continue;
            builder.add((Object)key);
        }
        ImmutableSet retVal = builder.build();
        return retVal.isEmpty() ? null : retVal;
    }

    @Override
    ListenableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        final SettableFuture future = SettableFuture.create();
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ImmutableMap.Builder metadataSnapshot = ImmutableMap.builder();
                for (XdsResourceType resourceType : XdsClientImpl.this.resourceSubscribers.keySet()) {
                    ImmutableMap.Builder metadataMap = ImmutableMap.builder();
                    for (Map.Entry resourceEntry : ((Map)XdsClientImpl.this.resourceSubscribers.get(resourceType)).entrySet()) {
                        metadataMap.put((Object)((String)resourceEntry.getKey()), (Object)((ResourceSubscriber)resourceEntry.getValue()).metadata);
                    }
                    metadataSnapshot.put((Object)resourceType, (Object)metadataMap.buildOrThrow());
                }
                future.set((Object)metadataSnapshot.buildOrThrow());
            }
        });
        return future;
    }

    @Override
    TlsContextManager getTlsContextManager() {
        return this.tlsContextManager;
    }

    @Override
    public <T extends XdsClient.ResourceUpdate> void watchXdsResource(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher, final Executor watcherExecutor) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber;
                if (!XdsClientImpl.this.resourceSubscribers.containsKey(type)) {
                    XdsClientImpl.this.resourceSubscribers.put(type, new HashMap());
                    XdsClientImpl.this.subscribedResourceTypeUrls.put(type.typeUrl(), type);
                }
                if ((subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName)) == null) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe {0} resource {1}", type, resourceName);
                    subscriber = new ResourceSubscriber(type, resourceName);
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).put(resourceName, subscriber);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(type);
                    }
                }
                subscriber.addWatcher(watcher, watcherExecutor);
            }
        });
    }

    @Override
    public <T extends XdsClient.ResourceUpdate> void cancelXdsResourceWatch(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).remove(resourceName);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(type);
                    }
                    if (((Map)XdsClientImpl.this.resourceSubscribers.get(type)).isEmpty()) {
                        XdsClientImpl.this.resourceSubscribers.remove(type);
                        XdsClientImpl.this.subscribedResourceTypeUrls.remove(type.typeUrl());
                    }
                }
            }
        });
    }

    @Override
    LoadStatsManager2.ClusterDropStats addClusterDropStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2 loadStatsManager = this.loadStatsManagerMap.get(serverInfo);
        LoadStatsManager2.ClusterDropStats dropCounter = loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ((LoadReportClient)XdsClientImpl.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
            }
        });
        return dropCounter;
    }

    @Override
    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        LoadStatsManager2 loadStatsManager = this.loadStatsManagerMap.get(serverInfo);
        LoadStatsManager2.ClusterLocalityStats loadCounter = loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ((LoadReportClient)XdsClientImpl.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
            }
        });
        return loadCounter;
    }

    @Override
    Bootstrapper.BootstrapInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    @Override
    @VisibleForTesting
    Map<Bootstrapper.ServerInfo, LoadReportClient> getServerLrsClientMap() {
        return ImmutableMap.copyOf(this.serverLrsClientMap);
    }

    public String toString() {
        return this.logId.toString();
    }

    @Override
    public void startSubscriberTimersIfNeeded(final Bootstrapper.ServerInfo serverInfo) {
        if (this.isShutDown()) {
            return;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (XdsClientImpl.this.isShutDown()) {
                    return;
                }
                for (Map subscriberMap : XdsClientImpl.this.resourceSubscribers.values()) {
                    for (ResourceSubscriber subscriber : subscriberMap.values()) {
                        if (!subscriber.serverInfo.equals(serverInfo) || subscriber.respTimer != null) continue;
                        subscriber.restartTimer();
                    }
                }
            }
        });
    }

    private void cleanUpResourceTimers() {
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                subscriber.stopTimer();
            }
        }
    }

    private <T extends XdsClient.ResourceUpdate> void handleResourceUpdate(XdsResourceType.Args args, List<Any> resources, XdsResourceType<T> xdsResourceType, XdsClient.ProcessingTracker processingTracker) {
        XdsResourceType.ValidatedResourceUpdate<T> result = xdsResourceType.parse(args, resources);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received {0} Response version {1} nonce {2}. Parsed resources: {3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, result.unpackedResources);
        Map parsedResources = result.parsedResources;
        Set<String> invalidResources = result.invalidResources;
        List<String> errors = result.errors;
        String errorDetail = null;
        if (errors.isEmpty()) {
            Preconditions.checkArgument((boolean)invalidResources.isEmpty(), (Object)"found invalid resources but missing errors");
            this.serverChannelMap.get(args.serverInfo).ackResponse(xdsResourceType, args.versionInfo, args.nonce);
        } else {
            errorDetail = Joiner.on((char)'\n').join(errors);
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed processing {0} Response version {1} nonce {2}. Errors:\n{3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, errorDetail);
            this.serverChannelMap.get(args.serverInfo).nackResponse(xdsResourceType, args.nonce, errorDetail);
        }
        long updateTime = this.timeProvider.currentTimeNanos();
        Map subscribedResources = this.resourceSubscribers.getOrDefault(xdsResourceType, Collections.emptyMap());
        for (Map.Entry entry : subscribedResources.entrySet()) {
            String resourceName = (String)entry.getKey();
            ResourceSubscriber subscriber = (ResourceSubscriber)entry.getValue();
            if (parsedResources.containsKey(resourceName)) {
                subscriber.onData(parsedResources.get(resourceName), args.versionInfo, updateTime, processingTracker);
                continue;
            }
            if (invalidResources.contains(resourceName)) {
                subscriber.onRejected(args.versionInfo, updateTime, errorDetail);
            }
            if (!xdsResourceType.isFullStateOfTheWorld()) continue;
            if (invalidResources.contains(resourceName)) {
                if (subscriber.data != null) continue;
                subscriber.onError(Status.UNAVAILABLE.withDescription(errorDetail), processingTracker);
                continue;
            }
            if (!subscriber.serverInfo.equals(args.serverInfo)) continue;
            subscriber.onAbsent(processingTracker);
        }
    }

    private final class ResourceSubscriber<T extends XdsClient.ResourceUpdate> {
        @Nullable
        private final Bootstrapper.ServerInfo serverInfo;
        @Nullable
        private final ControlPlaneClient xdsChannel;
        private final XdsResourceType<T> type;
        private final String resource;
        private final Map<XdsClient.ResourceWatcher<T>, Executor> watchers = new HashMap<XdsClient.ResourceWatcher<T>, Executor>();
        @Nullable
        private T data;
        private boolean absent;
        private boolean resourceDeletionIgnored;
        @Nullable
        private SynchronizationContext.ScheduledHandle respTimer;
        @Nullable
        private XdsClient.ResourceMetadata metadata;
        @Nullable
        private String errorDescription;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResourceSubscriber(XdsResourceType<T> type, String resource) {
            XdsClientImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.type = type;
            this.resource = resource;
            this.serverInfo = this.getServerInfo(resource);
            if (this.serverInfo == null) {
                this.errorDescription = "Wrong configuration: xds server does not exist for resource " + resource;
                this.xdsChannel = null;
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataUnknown();
            ControlPlaneClient xdsChannelTemp = null;
            try {
                XdsClientImpl.this.maybeCreateXdsChannelWithLrs(this.serverInfo);
                xdsChannelTemp = (ControlPlaneClient)XdsClientImpl.this.serverChannelMap.get(this.serverInfo);
                if (xdsChannelTemp.isInBackoff()) {
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                xdsChannelTemp = null;
                this.errorDescription = "Bad configuration:  " + e.getMessage();
                return;
            }
            finally {
                this.xdsChannel = xdsChannelTemp;
            }
            this.restartTimer();
        }

        @Nullable
        private Bootstrapper.ServerInfo getServerInfo(String resource) {
            if (BootstrapperImpl.enableFederation && resource.startsWith("xdstp:")) {
                Bootstrapper.AuthorityInfo authorityInfo;
                URI uri = URI.create(resource);
                String authority = uri.getAuthority();
                if (authority == null) {
                    authority = "";
                }
                if ((authorityInfo = (Bootstrapper.AuthorityInfo)XdsClientImpl.this.bootstrapInfo.authorities().get((Object)authority)) == null || authorityInfo.xdsServers().isEmpty()) {
                    return null;
                }
                return (Bootstrapper.ServerInfo)authorityInfo.xdsServers().get(0);
            }
            return (Bootstrapper.ServerInfo)XdsClientImpl.this.bootstrapInfo.servers().get(0);
        }

        void addWatcher(XdsClient.ResourceWatcher<T> watcher, Executor watcherExecutor) {
            Preconditions.checkArgument((!this.watchers.containsKey(watcher) ? 1 : 0) != 0, (String)"watcher %s already registered", watcher);
            this.watchers.put(watcher, watcherExecutor);
            T savedData = this.data;
            boolean savedAbsent = this.absent;
            watcherExecutor.execute(() -> {
                if (this.errorDescription != null) {
                    watcher.onError(Status.INVALID_ARGUMENT.withDescription(this.errorDescription));
                    return;
                }
                if (savedData != null) {
                    this.notifyWatcher(watcher, savedData);
                } else if (savedAbsent) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            });
        }

        void removeWatcher(XdsClient.ResourceWatcher<T> watcher) {
            Preconditions.checkArgument((boolean)this.watchers.containsKey(watcher), (String)"watcher %s not registered", watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            if (!this.xdsChannel.isReady()) {
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataRequested();
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", ResourceSubscriber.this.type, ResourceSubscriber.this.resource);
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent(null);
                }

                public String toString() {
                    return ResourceSubscriber.this.type + this.getClass().getSimpleName();
                }
            }
            this.respTimer = XdsClientImpl.this.syncContext.schedule((Runnable)new ResourceNotFound(), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        void cancelResourceWatch() {
            if (this.isWatched()) {
                throw new IllegalStateException("Can't cancel resource watch with active watchers present");
            }
            this.stopTimer();
            String message = "Unsubscribing {0} resource {1} from server {2}";
            XdsLogger.XdsLogLevel logLevel = XdsLogger.XdsLogLevel.INFO;
            if (this.resourceDeletionIgnored) {
                message = message + " for which we previously ignored a deletion";
                logLevel = XdsLogger.XdsLogLevel.FORCE_INFO;
            }
            XdsClientImpl.this.logger.log(logLevel, message, this.type, this.resource, this.serverInfo != null ? this.serverInfo.target() : "unknown");
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        boolean hasResult() {
            return this.data != null || this.absent;
        }

        void onData(XdsResourceType.ParsedResource<T> parsedResource, String version, long updateTime, XdsClient.ProcessingTracker processingTracker) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataAcked(parsedResource.getRawResource(), version, updateTime);
            T oldData = this.data;
            this.data = parsedResource.getResourceUpdate();
            this.absent = false;
            if (this.resourceDeletionIgnored) {
                XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_INFO, "xds server {0}: server returned new version of resource for which we previously ignored a deletion: type {1} name {2}", this.serverInfo != null ? this.serverInfo.target() : "unknown", this.type, this.resource);
                this.resourceDeletionIgnored = false;
            }
            if (!Objects.equals(oldData, this.data)) {
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers.keySet()) {
                    processingTracker.startTask();
                    this.watchers.get(watcher).execute(() -> {
                        try {
                            this.notifyWatcher(watcher, this.data);
                        }
                        finally {
                            processingTracker.onComplete();
                        }
                    });
                }
            }
        }

        void onAbsent(@Nullable XdsClient.ProcessingTracker processingTracker) {
            boolean ignoreResourceDeletionEnabled;
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            boolean bl = ignoreResourceDeletionEnabled = this.serverInfo != null && this.serverInfo.ignoreResourceDeletion();
            if (ignoreResourceDeletionEnabled && this.type.isFullStateOfTheWorld() && this.data != null) {
                if (!this.resourceDeletionIgnored) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_WARNING, "xds server {0}: ignoring deletion for resource type {1} name {2}}", this.serverInfo.target(), this.type, this.resource);
                    this.resourceDeletionIgnored = true;
                }
                return;
            }
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", this.type, this.resource);
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                this.metadata = XdsClient.ResourceMetadata.newResourceMetadataDoesNotExist();
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers.keySet()) {
                    if (processingTracker != null) {
                        processingTracker.startTask();
                    }
                    this.watchers.get(watcher).execute(() -> {
                        try {
                            watcher.onResourceDoesNotExist(this.resource);
                        }
                        finally {
                            if (processingTracker != null) {
                                processingTracker.onComplete();
                            }
                        }
                    });
                }
            }
        }

        void onError(Status error, @Nullable XdsClient.ProcessingTracker tracker) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorAugmented = Status.fromCode((Status.Code)error.getCode()).withDescription(description + "nodeID: " + XdsClientImpl.this.bootstrapInfo.node().getId()).withCause(error.getCause());
            for (XdsClient.ResourceWatcher watcher : this.watchers.keySet()) {
                if (tracker != null) {
                    tracker.startTask();
                }
                this.watchers.get(watcher).execute(() -> {
                    try {
                        watcher.onError(errorAugmented);
                    }
                    finally {
                        if (tracker != null) {
                            tracker.onComplete();
                        }
                    }
                });
            }
        }

        void onRejected(String rejectedVersion, long rejectedTime, String rejectedDetails) {
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataNacked(this.metadata, rejectedVersion, rejectedTime, rejectedDetails);
        }

        private void notifyWatcher(XdsClient.ResourceWatcher<T> watcher, T update) {
            watcher.onChanged(update);
        }
    }
}

