/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.nifi.repository.schema.ComplexRecordField;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SimpleRecordField;

public class ContentClaimSchema {
    public static final String CLAIM_CONTAINER = "Container";
    public static final String CLAIM_SECTION = "Section";
    public static final String CLAIM_IDENTIFIER = "Identifier";
    public static final String LOSS_TOLERANT = "Loss Tolerant";
    public static final String RESOURCE_CLAIM = "Resource Claim";
    public static final String RESOURCE_CLAIM_OFFSET = "Resource Claim Offset";
    public static final String CONTENT_CLAIM_OFFSET = "Content Claim Offset";
    public static final String CONTENT_CLAIM_LENGTH = "Content Claim Length";
    public static final RecordSchema CONTENT_CLAIM_SCHEMA_V1;
    public static final RecordSchema RESOURCE_CLAIM_SCHEMA_V1;

    static {
        ArrayList<SimpleRecordField> resourceClaimFields = new ArrayList<SimpleRecordField>();
        resourceClaimFields.add(new SimpleRecordField(CLAIM_CONTAINER, FieldType.STRING, Repetition.EXACTLY_ONE));
        resourceClaimFields.add(new SimpleRecordField(CLAIM_SECTION, FieldType.STRING, Repetition.EXACTLY_ONE));
        resourceClaimFields.add(new SimpleRecordField(CLAIM_IDENTIFIER, FieldType.STRING, Repetition.EXACTLY_ONE));
        resourceClaimFields.add(new SimpleRecordField(LOSS_TOLERANT, FieldType.BOOLEAN, Repetition.EXACTLY_ONE));
        RESOURCE_CLAIM_SCHEMA_V1 = new RecordSchema(Collections.unmodifiableList(resourceClaimFields));
        ArrayList<Object> contentClaimFields = new ArrayList<Object>();
        contentClaimFields.add(new ComplexRecordField(RESOURCE_CLAIM, Repetition.EXACTLY_ONE, resourceClaimFields));
        contentClaimFields.add(new SimpleRecordField(RESOURCE_CLAIM_OFFSET, FieldType.LONG, Repetition.EXACTLY_ONE));
        contentClaimFields.add(new SimpleRecordField(CONTENT_CLAIM_OFFSET, FieldType.LONG, Repetition.EXACTLY_ONE));
        contentClaimFields.add(new SimpleRecordField(CONTENT_CLAIM_LENGTH, FieldType.LONG, Repetition.EXACTLY_ONE));
        CONTENT_CLAIM_SCHEMA_V1 = new RecordSchema(Collections.unmodifiableList(contentClaimFields));
    }
}

