/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.service.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.util.StringUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Assertion;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;

public class ResponseAuthenticationConverter
implements Converter<OpenSamlAuthenticationProvider.ResponseToken, Saml2Authentication> {
    private static final Converter<OpenSamlAuthenticationProvider.ResponseToken, Saml2Authentication> defaultConverter = OpenSamlAuthenticationProvider.createDefaultResponseAuthenticationConverter();
    private final String groupAttributeName;

    public ResponseAuthenticationConverter(String groupAttributeName) {
        this.groupAttributeName = groupAttributeName;
    }

    public Saml2Authentication convert(OpenSamlAuthenticationProvider.ResponseToken responseToken) {
        Objects.requireNonNull(responseToken, "Response Token required");
        List assertions = responseToken.getResponse().getAssertions();
        Saml2Authentication authentication = (Saml2Authentication)Objects.requireNonNull(defaultConverter.convert((Object)responseToken), "Authentication required");
        Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)authentication.getPrincipal();
        return new Saml2Authentication((AuthenticatedPrincipal)principal, authentication.getSaml2Response(), this.getAuthorities(assertions));
    }

    private Collection<? extends GrantedAuthority> getAuthorities(List<Assertion> assertions) {
        Collection<Object> authorities = StringUtils.isBlank((String)this.groupAttributeName) ? Collections.emptyList() : (Collection)assertions.stream().flatMap(assertion -> assertion.getAttributeStatements().stream()).flatMap(attributeStatement -> attributeStatement.getAttributes().stream()).filter(attribute -> this.groupAttributeName.equals(attribute.getName())).flatMap(attribute -> attribute.getAttributeValues().stream()).map(this::getAttributeValue).filter(Objects::nonNull).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        return authorities;
    }

    private String getAttributeValue(XMLObject xmlObject) {
        String attributeValue;
        if (xmlObject instanceof XSAny) {
            XSAny any = (XSAny)xmlObject;
            attributeValue = any.getTextContent();
        } else if (xmlObject instanceof XSString) {
            XSString string = (XSString)xmlObject;
            attributeValue = string.getValue();
        } else {
            attributeValue = null;
        }
        return attributeValue;
    }
}

