/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.spring;

import java.io.File;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.kerberos.AlternateKerberosUserDetailsService;
import org.apache.nifi.web.security.kerberos.KerberosService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.GlobalSunJaasKerberosConfig;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;

public class KerberosServiceFactoryBean
implements FactoryBean<KerberosService> {
    private KerberosService kerberosService = null;
    private NiFiProperties properties = null;

    public KerberosService getObject() throws Exception {
        if (this.kerberosService == null && this.properties.isKerberosSpnegoSupportEnabled()) {
            File krb5ConfigFile = this.properties.getKerberosConfigurationFile();
            if (krb5ConfigFile != null) {
                GlobalSunJaasKerberosConfig krb5Config = new GlobalSunJaasKerberosConfig();
                krb5Config.setKrbConfLocation(krb5ConfigFile.getAbsolutePath());
                krb5Config.afterPropertiesSet();
            }
            this.kerberosService = new KerberosService();
            this.kerberosService.setKerberosServiceAuthenticationProvider(this.createKerberosServiceAuthenticationProvider());
        }
        return this.kerberosService;
    }

    public Class<?> getObjectType() {
        return KerberosService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    private KerberosServiceAuthenticationProvider createKerberosServiceAuthenticationProvider() throws Exception {
        KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider = new KerberosServiceAuthenticationProvider();
        kerberosServiceAuthenticationProvider.setTicketValidator(this.createTicketValidator());
        kerberosServiceAuthenticationProvider.setUserDetailsService((UserDetailsService)this.createAlternateKerberosUserDetailsService());
        kerberosServiceAuthenticationProvider.afterPropertiesSet();
        return kerberosServiceAuthenticationProvider;
    }

    private AlternateKerberosUserDetailsService createAlternateKerberosUserDetailsService() {
        return new AlternateKerberosUserDetailsService();
    }

    private KerberosTicketValidator createTicketValidator() throws Exception {
        SunJaasKerberosTicketValidator ticketValidator = new SunJaasKerberosTicketValidator();
        ticketValidator.setServicePrincipal(this.properties.getKerberosSpnegoPrincipal());
        ticketValidator.setKeyTabLocation((Resource)new FileSystemResource(this.properties.getKerberosSpnegoKeytabLocation()));
        ticketValidator.afterPropertiesSet();
        return ticketValidator;
    }
}

