/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution.locks;

import jetbrains.exodus.core.execution.locks.Latch;

class ReleaseLatch
extends Latch {
    protected Thread owner = null;

    ReleaseLatch() {
    }

    @Override
    public synchronized String getOwnerName() {
        return this.owner == null ? "no owner" : this.owner.getName();
    }

    @Override
    public synchronized void acquire() throws InterruptedException {
        while (this.owner != null) {
            this.wait();
        }
        this.owner = Thread.currentThread();
    }

    @Override
    public synchronized boolean acquire(long timeout) throws InterruptedException {
        if (this.owner != null) {
            this.wait(timeout);
            if (this.owner != null) {
                return false;
            }
        }
        this.owner = Thread.currentThread();
        return true;
    }

    @Override
    public synchronized boolean tryAcquire() {
        if (this.owner != null) {
            return false;
        }
        this.owner = Thread.currentThread();
        return true;
    }

    @Override
    public synchronized void release() {
        this.owner = null;
        this.notify();
    }
}

