/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.params.AbstractUpdateParamContextCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterContextReferenceDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;

public class SetInheritedParamContexts
extends AbstractUpdateParamContextCommand<VoidResult> {
    public SetInheritedParamContexts() {
        super("set-inherited-param-contexts", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Sets a list of parameter context ids from which the given parameter context should inherit parameters";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.PARAM_CONTEXT_INHERITED_IDS.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String inheritedIds = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_INHERITED_IDS);
        int updateTimeout = this.getUpdateTimeout(properties);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity existingParameterContextEntity = paramContextClient.getParamContext(paramContextId, false);
        String[] inheritedIdArray = inheritedIds.split(",");
        ArrayList<ParameterContextReferenceEntity> referenceEntities = new ArrayList<ParameterContextReferenceEntity>();
        for (String inheritedId : inheritedIdArray) {
            ParameterContextEntity existingInheritedEntity = paramContextClient.getParamContext(inheritedId, false);
            ParameterContextReferenceEntity parameterContextReferenceEntity = new ParameterContextReferenceEntity();
            parameterContextReferenceEntity.setId(existingInheritedEntity.getId());
            ParameterContextReferenceDTO parameterContextReferenceDTO = new ParameterContextReferenceDTO();
            parameterContextReferenceDTO.setName(existingInheritedEntity.getComponent().getName());
            parameterContextReferenceDTO.setId(existingInheritedEntity.getComponent().getId());
            parameterContextReferenceEntity.setComponent(parameterContextReferenceDTO);
            referenceEntities.add(parameterContextReferenceEntity);
        }
        ParameterContextDTO parameterContextDTO = new ParameterContextDTO();
        parameterContextDTO.setId(existingParameterContextEntity.getId());
        parameterContextDTO.setParameters(existingParameterContextEntity.getComponent().getParameters());
        ParameterContextEntity updatedParameterContextEntity = new ParameterContextEntity();
        updatedParameterContextEntity.setId(paramContextId);
        updatedParameterContextEntity.setComponent(parameterContextDTO);
        updatedParameterContextEntity.setRevision(existingParameterContextEntity.getRevision());
        parameterContextDTO.setInheritedParameterContexts(referenceEntities);
        ParameterContextUpdateRequestEntity updateRequestEntity = paramContextClient.updateParamContext(updatedParameterContextEntity);
        this.performUpdate(paramContextClient, updatedParameterContextEntity, updateRequestEntity, updateTimeout);
        if (this.isInteractive()) {
            this.println();
        }
        return VoidResult.getInstance();
    }
}

