/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.tenants;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;

public class CreateUserGroup
extends AbstractNiFiCommand<StringResult> {
    public CreateUserGroup() {
        super("create-user-group", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates new user group.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.UG_NAME.createOption());
        this.addOption(CommandOption.USER_NAME_LIST.createOption());
        this.addOption(CommandOption.USER_ID_LIST.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String userGroupId = this.getRequiredArg(properties, CommandOption.UG_NAME);
        String users = this.getArg(properties, CommandOption.USER_NAME_LIST);
        String userIds = this.getArg(properties, CommandOption.USER_ID_LIST);
        UserGroupDTO userGroupDTO = new UserGroupDTO();
        userGroupDTO.setIdentity(userGroupId);
        HashSet<TenantEntity> tenantEntities = new HashSet<TenantEntity>();
        if (StringUtils.isNotBlank((CharSequence)users)) {
            tenantEntities.addAll(CreateUserGroup.generateTenantEntities(users, client.getTenantsClient().getUsers()));
        }
        if (StringUtils.isNotBlank((CharSequence)userIds)) {
            tenantEntities.addAll(CreateUserGroup.generateTenantEntities(userIds));
        }
        userGroupDTO.setUsers(tenantEntities);
        UserGroupEntity userGroupEntity = new UserGroupEntity();
        userGroupEntity.setComponent(userGroupDTO);
        userGroupEntity.setRevision(this.getInitialRevisionDTO());
        UserGroupEntity createdEntity = client.getTenantsClient().createUserGroup(userGroupEntity);
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

