/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached.iterator;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReverseEntityIdArrayIteratorMultiTypeIdPacked
extends NonDisposableEntityIterator {
    private final int[] typeIds;
    private final long[] localIds;
    private int index;
    private int typeId = -1;
    private int typeIndex;
    private int currentBound;

    public ReverseEntityIdArrayIteratorMultiTypeIdPacked(@NotNull EntityIterableBase iterable2, int[] typeIds, long[] localIds) {
        super(iterable2);
        this.typeIds = typeIds;
        this.localIds = localIds;
        this.index = localIds.length;
        this.typeIndex = typeIds.length - 1;
        this.currentBound = localIds.length;
    }

    @Override
    public boolean skip(int number) {
        int index2;
        this.index = index2 = this.index - number;
        if (this.hasNextImpl()) {
            while (index2 <= this.currentBound) {
                --this.typeIndex;
                this.typeId = this.typeIds[this.typeIndex];
                if (this.typeIndex > 0) {
                    --this.typeIndex;
                    this.currentBound = this.typeIds[this.typeIndex];
                    continue;
                }
                this.currentBound = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public EntityId nextId() {
        int index2;
        if ((index2 = --this.index) < this.currentBound) {
            --this.typeIndex;
            this.typeId = this.typeIds[this.typeIndex];
            if (this.typeIndex > 0) {
                --this.typeIndex;
                this.currentBound = this.typeIds[this.typeIndex];
            } else {
                this.currentBound = 0;
            }
        }
        return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, this.localIds[index2]);
    }

    @Override
    @Nullable
    public EntityId getLast() {
        int typeId;
        if (this.localIds.length == 0 || (typeId = this.typeIds[0]) == Integer.MIN_VALUE) {
            return null;
        }
        return new PersistentEntityId(typeId, this.localIds[0]);
    }

    @Override
    @Nullable
    public EntityId nextIdImpl() {
        int index2;
        if ((index2 = --this.index) < this.currentBound) {
            --this.typeIndex;
            this.typeId = this.typeIds[this.typeIndex];
            if (this.typeIndex > 0) {
                --this.typeIndex;
                this.currentBound = this.typeIds[this.typeIndex];
            } else {
                this.currentBound = 0;
            }
        }
        return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, this.localIds[index2]);
    }

    @Override
    protected boolean hasNextImpl() {
        return this.index > 0;
    }

    @Override
    protected int getIndex() {
        return this.index;
    }
}

