/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.AbstractMemoryCR;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Numbers;
import io.questdb.std.Vect;
import io.questdb.std.str.LPSZ;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryCMARWImpl
extends AbstractMemoryCR
implements MemoryCMARW,
MemoryCARW,
MemoryMAR {
    private static final Log LOG = LogFactory.getLog(MemoryCMARWImpl.class);
    private final Long256Acceptor long256Acceptor = this::putLong256;
    private long appendAddress = 0L;
    private long extendSegmentMsb;
    private int madviseOpts = -1;
    private int memoryTag = 0;
    private long minMappedMemorySize = -1L;

    public MemoryCMARWImpl(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, long opts) {
        this.of(ff, name, extendSegmentSize, size, memoryTag, opts, -1);
    }

    public MemoryCMARWImpl() {
    }

    @Override
    public long appendAddressFor(long bytes) {
        this.checkAndExtend(this.appendAddress + bytes);
        long result = this.appendAddress;
        this.appendAddress += bytes;
        return result;
    }

    @Override
    public long appendAddressFor(long offset, long bytes) {
        this.checkAndExtend(this.pageAddress + offset + bytes);
        return this.pageAddress + offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean truncate, byte truncateMode) {
        if (this.pageAddress != 0L) {
            long truncateSize;
            if (truncate) {
                long sz;
                long appendOffset = this.getAppendOffset();
                if (appendOffset < (sz = Math.min(this.size, truncateSize = truncateMode == 0 ? Files.ceilPageSize(appendOffset) : appendOffset))) {
                    Vect.memset(this.pageAddress + appendOffset, sz - appendOffset, 0);
                }
            } else {
                truncateSize = -1L;
            }
            this.ff.munmap(this.pageAddress, this.size, this.memoryTag);
            this.pageAddress = 0L;
            try {
                Vm.bestEffortClose(this.ff, LOG, this.fd, truncateSize, truncateMode);
            }
            finally {
                this.fd = -1;
            }
        }
        if (this.ff != null && this.ff.close(this.fd)) {
            LOG.debug().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1;
        }
        this.size = 0L;
        this.ff = null;
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void extend(long newSize) {
        if (newSize > this.size) {
            this.extend0(newSize);
        }
    }

    @Override
    public long getAppendAddress() {
        return this.appendAddress;
    }

    @Override
    public long getAppendAddressSize() {
        return this.lim - this.appendAddress;
    }

    @Override
    public long getAppendOffset() {
        return this.appendAddress - this.pageAddress;
    }

    @Override
    public long getExtendSegmentSize() {
        return this.extendSegmentMsb;
    }

    @Override
    public int getFd() {
        return this.fd;
    }

    @Override
    public void jumpTo(long offset) {
        this.checkAndExtend(this.pageAddress + offset);
        this.appendAddress = this.pageAddress + offset;
        assert (this.appendAddress <= this.lim);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, int memoryTag, long opts) {
        this.of(ff, name, extendSegmentSize, -1L, memoryTag, opts);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, long opts, int madviseOpts) {
        this.extendSegmentMsb = Numbers.msb(extendSegmentSize);
        this.minMappedMemorySize = extendSegmentSize;
        this.madviseOpts = madviseOpts;
        this.openFile(ff, name, opts);
        this.map(ff, name, size, memoryTag);
    }

    @Override
    public void of(FilesFacade ff, int fd, @Nullable CharSequence name, long size, int memoryTag) {
        this.close();
        assert (fd > 0);
        this.ff = ff;
        this.minMappedMemorySize = this.extendSegmentMsb = ff.getMapPageSize();
        this.fd = fd;
        this.map(ff, name, size, memoryTag);
    }

    @Override
    public void of(FilesFacade ff, int fd, @Nullable CharSequence name, long extendSegmentSize, long size, int memoryTag) {
        this.of(ff, fd, null, size, memoryTag);
        this.extendSegmentMsb = Numbers.msb(extendSegmentSize);
    }

    @Override
    public void putLong256(@NotNull CharSequence hexString, int start, int end) {
        this.putLong256(hexString, start, end, this.long256Acceptor);
    }

    @Override
    public void setTruncateSize(long size) {
        this.jumpTo(size);
    }

    @Override
    public void skip(long bytes) {
        this.checkAndExtend(this.appendAddress + bytes);
        this.appendAddress += bytes;
    }

    @Override
    public void switchTo(int fd, long offset, byte truncateMode) {
        this.close(true, truncateMode);
        this.fd = fd;
        this.map(this.ff, null, offset, this.memoryTag);
    }

    @Override
    public void sync(boolean async) {
        if (this.pageAddress != 0L && this.ff.msync(this.pageAddress, this.size, async) == 0) {
            return;
        }
        LOG.error().$("could not msync [fd=").$(this.fd).$(']').$();
    }

    @Override
    public void truncate() {
        if (this.pageAddress != 0L) {
            long fileSize = this.ff.length(this.fd);
            long sz = Math.min(fileSize, this.minMappedMemorySize);
            try {
                this.pageAddress = TableUtils.mremap(this.ff, this.fd, this.pageAddress, this.size, sz, 2, this.memoryTag);
            }
            catch (Throwable e) {
                this.appendAddress = this.pageAddress;
                long truncatedToSize = Vm.bestEffortTruncate(this.ff, LOG, this.fd, 0L);
                if (truncatedToSize != 0L) {
                    if (truncatedToSize > 0L) {
                        Vect.memset(this.pageAddress, truncatedToSize, 0);
                        this.size = sz;
                    } else {
                        Vect.memset(this.pageAddress, this.size, 0);
                    }
                    this.lim = this.pageAddress + this.size;
                }
                throw e;
            }
            this.size = sz;
            this.lim = this.pageAddress + sz;
            this.appendAddress = this.pageAddress;
            Vect.memset(this.pageAddress, sz, 0);
            if (this.ff.truncate(this.fd, Files.ceilPageSize(this.size))) {
                return;
            }
            long mem = TableUtils.mapRW(this.ff, this.fd, this.ff.length(this.fd), this.memoryTag);
            Vect.memset(mem + sz, fileSize - sz, 0);
            this.ff.munmap(mem, fileSize, this.memoryTag);
        }
    }

    @Override
    public void zero() {
        long baseLength = this.lim - this.pageAddress;
        Vect.memset(this.pageAddress, baseLength, 0);
    }

    private void checkAndExtend(long address) {
        if (address <= this.lim) {
            return;
        }
        this.extend0(address - this.pageAddress);
    }

    private void extend0(long newSize) {
        long nPages = (newSize >>> (int)this.extendSegmentMsb) + 1L;
        newSize = nPages << (int)this.extendSegmentMsb;
        long offset = this.appendAddress - this.pageAddress;
        long previousSize = this.size;
        assert (this.size > 0L);
        TableUtils.allocateDiskSpace(this.ff, this.fd, newSize);
        try {
            this.pageAddress = TableUtils.mremap(this.ff, this.fd, this.pageAddress, previousSize, newSize, 2, this.memoryTag);
            this.ff.madvise(this.pageAddress, newSize, this.madviseOpts);
        }
        catch (Throwable e) {
            this.appendAddress = this.pageAddress + previousSize;
            this.close(false);
            throw e;
        }
        this.size = newSize;
        this.lim = this.pageAddress + newSize;
        this.appendAddress = this.pageAddress + offset;
    }

    private void map0(FilesFacade ff, long size) {
        try {
            this.pageAddress = TableUtils.mapRW(ff, this.fd, size, this.memoryTag);
            this.lim = this.pageAddress + size;
            ff.madvise(this.pageAddress, size, this.madviseOpts);
        }
        catch (Throwable e) {
            this.close(false);
            throw e;
        }
    }

    private void openFile(FilesFacade ff, LPSZ name, long opts) {
        this.close();
        this.ff = ff;
        this.fd = TableUtils.openFileRWOrFail(ff, name, opts);
    }

    protected void map(FilesFacade ff, @Nullable CharSequence name, long size, int memoryTag) {
        this.memoryTag = memoryTag;
        if (size < 1L) {
            this.size = this.minMappedMemorySize;
            TableUtils.allocateDiskSpace(ff, this.fd, this.size);
            this.map0(ff, this.minMappedMemorySize);
            this.appendAddress = this.pageAddress;
        } else {
            this.size = size;
            this.map0(ff, size);
            this.appendAddress = this.pageAddress + size;
        }
        if (name != null) {
            LOG.debug().$("open [file=").$(name).$(", fd=").$(this.fd).$(", pageSize=").$(size).$(", size=").$(this.size).$(']').$();
        } else {
            LOG.debug().$("open [fd=").$(this.fd).$(", pageSize=").$(size).$(", size=").$(this.size).$(']').$();
        }
    }
}

